/**
 * 
 */
package cn.smarthse.modules.datacentre.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《企业搜索Model》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年6月12日-下午1:31:49
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CompanySearchModel implements Serializable {
	private static final long serialVersionUID = -7290265330709069293L;

	@ApiModelProperty(value="当前页数")
	private  int pageNum = 1;
	
	@ApiModelProperty(value="每页条数")
	private  int pageSize = 10;
	
	
	/** 企业名称 **/
	@ApiModelProperty(value="企业名称")
	private String fullname = null;
	
	/**
	 * 平台字段）注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构
	 */
    @ApiModelProperty(value="平台字段）注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构")
	private Integer regType;
}
