/**
 * 
 */
package cn.smarthse.modules.datacentre.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《平台企业注册数据 包》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年5月30日-下午4:35:46
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CompanyRegInfoModel implements Serializable {
	private static final long serialVersionUID = 6560073316968044603L;

	/**
     * 注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构
     */
    @ApiModelProperty(value="注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构", required=true)
    private Integer regType;

    /**
     * 企业名称、医疗机构名称
     */
    @ApiModelProperty(value="企业名称、医疗机构名称", required=true)
    private String fullname;

    /**
     * 企业编号串(社会统一信代码/登记号/组织代码)
     */
    @ApiModelProperty(value="企业编号串(社会统一信代码/登记号/组织代码)", required=true)
    private String corpCc;

    /**
     * 所属行业
     */
    @ApiModelProperty(value="所属行业", required=true)
    private Long corpType;

    /**
     * 企业注册行政区域
     */
    @ApiModelProperty(value="企业注册行政区域", required=true)
    private Long corpAreaId;

    /**
     * 通讯地址
     */
    @ApiModelProperty(value="通讯地址", required=true)
    private String corpAddress;

    @ApiModelProperty(value="平台字段）证照照片Id")
	private Long corpFileId;
    
    /**
     * (营业执照/医疗机构职业许可证/资质证书)附件
     */
    @ApiModelProperty(value="(营业执照/医疗机构职业许可证/资质证书)附件", required=true)
    private String corpFileUrl;

    
    @ApiModelProperty(value="企业邮箱", required=true)
    private String corpEmail;

//    /**
//     * 申请时登录账号
//     */
//    @ApiModelProperty(value="申请时登录账号", required=true)
//    private String corpAdminUsername;
//
//    /**
//     * 申请时登录账号密码
//     */
//    @ApiModelProperty(value="申请时登录账号密码", required=true)
//    private String corpAdminPassword;
    
    /**
     * 申请人姓名
     */
    @ApiModelProperty(value="申请人姓名", required=true)
    private String corpApplyName;

    /**
     * 申请人手机号
     */
    @ApiModelProperty(value="申请人手机号", required=true)
    private String corpApplyMobile;

    
//    /**
//     * 企业编号串扩展(社会统一信代码/登记号/组织代码)
//     */
//    @ApiModelProperty(value="企业编号串扩展(社会统一信代码/登记号/组织代码)", required=false)
//    private String corpCcExtend;
    
}
