/**
 * 
 */
package cn.smarthse.modules.datacentre.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《治理用人单位基本情况登记表 Model（年度）》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年5月30日-下午4:06:20
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CompanyGovernModel implements Serializable {
	private static final long serialVersionUID = 7592273573480067342L;
	/**
	 * 企业id
	 */
	@ApiModelProperty(value="企业编号")
	private Long cid;
	
	/**
	 * 治理年份
	 */
	@ApiModelProperty(value="治理年份")
	private Integer governYear;
	
	/**
	 * fullname企业名称
	 */
    @ApiModelProperty(value="fullname企业名称")
	private String name;
    
    /**
     * 省编号
     */
    @ApiModelProperty(value="省编号")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty(value="省名称")
    private String provinceName;

    /**
     * 市编号
     */
    @ApiModelProperty(value="市编号")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty(value="市名称")
    private String cityName;

    /**
     * 区域ID
     */
    @ApiModelProperty(value="区域ID")
    private Long areaId;

    /**
     * 区域名称
     */
    @ApiModelProperty(value="区域名称")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @ApiModelProperty(value="乡镇街道编号")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @ApiModelProperty(value="乡镇街道名称")
    private String streetName;
    
    /**
	 * corp_address 企业通讯地址
	 */
    @ApiModelProperty(value="工作产所地址（工作场所地址）")
	private String workAddress;
    
    /**
	 * 企业规模（ID）
	 * @see cn.smarthse.modules.datacentre.enums.CompanySizeEnum
	 */
    @ApiModelProperty(value="企业规模")
	private String scale;
    
    /**
	 * 企业规模（ID）
	 */
    @ApiModelProperty(value="企业规模")
	private String scaleName;
    
    /**
	 * 注册类型
	 */
    @ApiModelProperty(value="注册类型")
	private Long registerType;
    @ApiModelProperty(value="注册类型名称")
    private String registerTypeName;
    
    
    /**
	 * corp_type 行业分类（sys_param.param_code）
	 */
    @ApiModelProperty(value="industryCategory 行业分类（sys_param.id）")
	private Long industryCategory;
    @ApiModelProperty(value="industryCategoryCode 行业分类名称（sys_param.param_valuecode）")
    private String industryCategoryCode;
    @ApiModelProperty(value="industryCategoryName 行业分类名称（sys_param.param_value）")
    private String industryCategoryName;

	/**
	 * 隐藏,所属行业Code地上/地下(冗余)
	 */
    @ApiModelProperty(value="isIndustryCategoryB true:地上   false地下")
	private Boolean isIndustryCategoryB;
    
    
    /**
	 * 在岗职工人数
	 */
    @ApiModelProperty(value="在岗职工人数")
	private Integer staffCount;
    
    //======================TODO 以下是治理属性===================================
	
	/**
	 * 接触尘毒危害人数
	 */
	@ApiModelProperty(value="接触尘毒危害人数")
	private Integer dustHarmsCount;
	/**
	 * 是否进行职业病危害项目申报
	 */
	@ApiModelProperty(value="是否进行职业病危害项目申报")
	private Boolean isOdiDeclareReport;
	/**
	 * 是否进行职业病危害定期检测
	 */
	@ApiModelProperty(value="是否进行职业病危害定期检测")
	private Boolean isOdiDeclareCheck;
	/**
	 * 接触尘毒危害劳动者职业健康检查人数
	 */
	@ApiModelProperty(value="接触尘毒危害劳动者职业健康检查人数")
	private Integer dustFcHarmsCount;
	/**
	 * 是否接受职业健康培训： 是否主要负责人
	 */
	@ApiModelProperty(value="是否接受职业健康培训： 是否主要负责人")
	private Boolean isHrManager;
	/**
	 * 是否接受职业健康培训：是否职业健康管理人员
	 */
	@ApiModelProperty(value="是否接受职业健康培训：是否职业健康管理人员")
	private Boolean isHrStaff;
	
	@ApiModelProperty(value="是否接受职业健康培训：劳动者")
	private Boolean isHrWorker;
	/**
	 * 填报人姓名：
	 */
	@ApiModelProperty(value="填报人姓名：")
	private String reportName;
	/**
	 * 填报人手机号码：
	 */
	@ApiModelProperty(value="填报人手机号码：")
	private String reportMobile;
}
