package cn.smarthse.modules.platform.sys.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

@Table(name = "sys_file")
public @Data class SysFile implements Serializable {
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
    private Long id;

    /**
     * OSS路径地址（相对）
     */
    private String ossUrl;

    /**
     * 附件名
     */
    private String fileName;

    /**
     * 附件大小
     */
    private String fileSize;

    /**
     * 附件扩展名（可用于图标展示）
     */
    private String fileExt;

    /**
     * 附件Hash
     */
    private String fileHash;

    /**
     * 上传IP
     */
    private String creatorIp;

    /**
     * 附件描述
     */
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    
    //===========TODO  属性数据======================
    @Transient
    private String fullOssurl;
}