package cn.smarthse.modules.platform.model;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * 《AdminSysLegal》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:
 * @Comments:  <系统法律法规>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-7-24-上午9:09:10
 */
public @Data class AdminSysLegal implements Serializable {
    /**
     * ID
     */
    private Long id;

    /**
     * 中文名称
     */
    private String title;

    /**
     * 英文名称
     */
    private String titleEn;

    /**
     * 法律法规标准号
     */
    private String fileNo;

    /**
     * 状态(1-现行,2-作废, 3-即将实施,4-废止)
     */
    private Integer legalStatus;

    /**
     * 中国标准分类号
     */
    private String ccs;

    /**
     * 国际标准分类号
     */
    private String ics;

    /**
     * 类型
     */
    private Integer legalType;

    /**
     * 发布日期
     */
    private Date issuanceDate;

    /**
     * 实施日期
     */
    private Date executeDate;

    /**
     * 作废日期
     */
    private Date lnvalidDate;

    /**
     * 主管部门
     */
    private String governor;

    /**
     * 颁布部门
     */
    private String departmentIssued;

    /**
     * 链接
     */
    private String webLnk;
    
    /**
     * 备注
     */
    private String remark;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改者
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效(1-有效,0-无效)
     */
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
}