/**
 * 
 */
package cn.smarthse.modules.platform.enums;

/**
 * 《软件支付类型定义》
 * <li>0-转账，1-支付宝，2-微信
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-24-上午9:36:11
 */
public enum PayTypeEnum {
		/**
		 * 线下汇款转账
		 */
		offline_transfer("线下转账", (byte) 0),
		/**
		 * 支付宝
		 */
		online_alipay("支付宝", (byte) 1),
		/**
		 * 已拒绝
		 */
		online_weixin("微信", (byte) 2);
		
	
		// 成员变量
		private Byte state;
		private String value;

		// 构造方法
		private PayTypeEnum(String value, Byte state) {
			this.state = state;
			this.value = value;
		}

		// get set 方法

		/**
		 * @return the state
		 */
		public Byte getState() {
			return state;
		}

		/**
		 * @param state
		 *            the state to set
		 */
		public void setState(Byte state) {
			this.state = state;
		}

		/**
		 * @return the value
		 */
		public String getValue() {
			return value;
		}

		/**
		 * @param value
		 *            the value to set
		 */
		public void setValue(String value) {
			this.value = value;
		}
	
}
