/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.datacentre.provider.system;

import java.util.List;

import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;



 /**
 * 
 * 《DC 系统参数Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-07-08 02:44
 */
public interface ISysParamProvideService {
	
	/**
	 * 根据ID获取单条数据
	 * @param id
	 * @return
	 */
	SysParamModel getById(Long id);
	
	/**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     *
     * @param ids 如 "1,2,3,4"
     * @return
     */
	List<SysParamModel> getListByIds(String ids);
	
	
	/**
	 * 读取参数列表(包含顶级父节点)
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-上午11:23:48
	 * @param paramGroup
	 * @return
	 */
	List<SysParamModel> getSysParamList(String paramGroup);
	
	/**
	 * 读取参数列表(不包含顶级父节点)
	 * <li>即parentId is null
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-上午11:23:48
	 * @param paramGroup
	 * @return
	 */
	List<SysParamModel> getSysParamListByChildren(String paramGroup);

	/**
	 * 读取完整层级名称
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年5月13日-下午3:10:52
	 * @param corpType
	 */
	String getNames(Long id);

	/**
	 * 根据上级Id，读取下级列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年5月13日-下午3:16:15
	 * @param parentId
	 * @return
	 */
	List<SysParamModel> getListByPid(Long parentId);

	/**
	 * 
	 * @Comments:  <根据参数名，获取系统参数信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年6月14日-下午3:00:29
	 * @param paramValue  参数值
	 * @param cid
	 * @param group  参数分组
	 * @return
	 */
	SysParamModel getSysParamByName(String paramValue, Long cid, SysParamGroupEnum group);

	/**
	 * 
	 * @Comments:  <根据paramCode，cid，group，paramValue，获取系统参数信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年6月14日-下午3:06:03
	 * @param paramValue  参数值
	 * @param cid
	 * @param group 参数分组
	 * @param paramCode  参数编码
	 * @return
	 */
	SysParamModel getSysParamByNameGroupCode(String paramValue, Long cid, SysParamGroupEnum group,	String paramCode);

//	/**
//	 * 
//	 * @Comments:  <根据分组查询系统参数>
//	 * @author BinXu(徐斌) [784514607@qq.com]
//	 * @since 2019年6月14日-下午4:03:12
//	 * @param group 参数分组
//	 * @return
//	 */
//	List<SysParamModel>  getListByGroup(SysParamGroupEnum group);




}
