/**
 * 
 */
package cn.smarthse.modules.datacentre.model.stat;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《企业基础统计>企业规模 》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年6月19日-上午8:38:33
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CompayParamStatModel implements Serializable {
	private static final long serialVersionUID = 3471047016811019273L;

	
	/**
	 * 父编号
	 */
	@ApiModelProperty(value="父编号")
	private Long pid;
	/**
	 * 参数类别(参数分组，用于取所有数据）
	 */
	@ApiModelProperty(value="行业分组名")
	private String paramGroup;
	
	@ApiModelProperty(value="参数Id")
	private Long paramId;
	/**
	 * 参数编码
	 */
	@ApiModelProperty(value="参数编号")
	private String paramCode;
	/**
     * 参数值
     */
    @ApiModelProperty(value="参数值")
    private String paramName;
    
    //企业Ids
    @ApiModelProperty(value="企业Ids, 多个用逗号隔开")
    private String companyIds;
    //企业数
    @ApiModelProperty(value="企业数")
    private Integer companyCount;
    
    //劳动者总人数
    @ApiModelProperty(value="劳动者总人数")
    private Integer workStaffCount;
    
    //接触有毒有害因素人数
    @ApiModelProperty(value="接触有毒有害因素人数")
    private Integer harmStaffCount;
    
    //职业病患病人数
    @ApiModelProperty(value="职业病患病人数")
    private Integer occStaffCount;
    
   
    
}
