/**
 * 
 */
package cn.smarthse.modules.datacentre.model;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《数据中心企业基础信息Model》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年5月30日-下午1:32:37
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CompanyBaseInfoModel implements Serializable {
	private static final long serialVersionUID = -798554499553566968L;

	@ApiModelProperty(value="企业编号, 与 cid同值")
	private Long id;
	
	@ApiModelProperty(value="企业编号")
	private Long cid;
    
    /**
     * 省编号
     */
    @ApiModelProperty(value="省编号")
    private Long provinceId;

    /**
     * 省名称
     */
    @ApiModelProperty(value="省名称")
    private String provinceName;

    /**
     * 市编号
     */
    @ApiModelProperty(value="市编号")
    private Long cityId;

    /**
     * 市名称
     */
    @ApiModelProperty(value="市名称")
    private String cityName;

    /**
     * 区域ID
     */
    @ApiModelProperty(value="区域ID")
    private Long areaId;

    /**
     * 区域名称
     */
    @ApiModelProperty(value="区域名称")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @ApiModelProperty(value="乡镇街道编号")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @ApiModelProperty(value="乡镇街道名称")
    private String streetName;
    
    @ApiModelProperty(value="行政区域详情：原始存放的编号")
    private Long areaDetailId;
    @ApiModelProperty(value="行政区域详情：省市区县街道")
    private String areaDetailName;

	@ApiModelProperty(value="行政区域 层级")
	private Byte areaLevel;

	/**
	 * fullname企业名称
	 */
    @ApiModelProperty(value="fullname企业名称")
	private String name;
	/**
	 * 企业名称简称
	 */
    @ApiModelProperty(value="企业名称简称")
	private String shortName;
	/**
	 * 上属公司（或主管单位）
	 */
    @ApiModelProperty(value="上属公司（或主管单位）")
	private String fatherDept;
	/**
	 * 成立时间
	 */
    @ApiModelProperty(value="成立时间")
	private java.util.Date settingTime;
	/**
	 * corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）
	 */
    @ApiModelProperty(value="corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）")
	private String unifiedSocialCc;
	/**
	 * corp_tel 企业联系电话	
	 */
    @ApiModelProperty(value="corp_tel 企业联系电话	")
	private String companyContactTel;
	/**
	 * corp_email 企业电子邮箱
	 */
    @ApiModelProperty(value="corp_email 企业电子邮箱	")
	private String companyContactEmail;
	/**
	 * 企业传真
	 */
    @ApiModelProperty(value="企业传真")
	private String companyContactFax;
//	/**
//	 * corp_area_id 行政区域区编号
//	 */
//    @ApiModelProperty(value="corp_area_id 行政区域区编号")
//	private Long areaId;
	/**
	 * 企业注册地详址
	 */
    @ApiModelProperty(value="企业注册地详址")
	private String registerAddress;
	/**
	 * 企业注册地址邮编
	 */
    @ApiModelProperty(value="企业注册地址邮编")
	private String registerPost;
	/**
	 * corp_address 企业通讯地址
	 */
    @ApiModelProperty(value="corp_address 企业通讯地址")
	private String companyPostalAdress;
	/**
	 * 工作产所地址（工作场所地址）
	 */
    @ApiModelProperty(value="工作产所地址（工作场所地址）")
	private String workAddress;
	/**
	 * 注册类型
	 */
    @ApiModelProperty(value="注册类型")
	private Long registerType;
    @ApiModelProperty(value="注册类型名称")
    private String registerTypeName;
    
	/**
	 * corp_type 行业分类（sys_param.param_code）
	 */
    @ApiModelProperty(value="corp_type 行业分类（sys_param.param_code）")
	private Long industryCategory;
    @ApiModelProperty(value="corp_type 行业分类名称（sys_param.param_code）")
    private String industryCategoryName;
	/**
	 * 职业病危害风险分类(0-严重、1-较重、2-一般)
	 */
    @ApiModelProperty(value="职业病危害风险分类(0-严重、1-较重、2-一般)")
	private Integer occupationalRiskClassify;
	/**
	 * 在岗职工人数
	 */
    @ApiModelProperty(value="在岗职工人数")
	private Integer staffCount;
	/**
	 * 接害人数（不重复计）
	 */
    @ApiModelProperty(value="接害人数（不重复计）")
	private Integer pickupCount;
	/**
	 * 主营营业收入（万元）
	 */
    @ApiModelProperty(value="主营营业收入（万元）")
	private java.math.BigDecimal mainOperaIncome;
	/**
	 * 注册资本
	 */
    @ApiModelProperty(value="注册资本")
	private java.math.BigDecimal registerCapital;
	/**
	 * 企业规模
	 */
    @ApiModelProperty(value="企业规模")
	private String scale;
    /**
	 * 企业规模
	 */
    @ApiModelProperty(value="企业规模(名称）")
	private String scaleName;
    
	/**
	 * 企业年度产值
	 */
    @ApiModelProperty(value="企业年度产值")
	private java.math.BigDecimal yearAssets;
	/**
	 * 企业资产总值
	 */
    @ApiModelProperty(value="企业资产总值")
	private java.math.BigDecimal totalAssets;
	/**
	 * 法人代表姓名
	 */
    @ApiModelProperty(value="法人代表姓名")
	private String legalName;
	/**
	 * 法人代表联系电话
	 */
    @ApiModelProperty(value="法人代表联系电话")
	private String legalTel;
	/**
	 * 化学事故应急咨询服务电话
	 */
    @ApiModelProperty(value="化学事故应急咨询服务电话")
	private String chemicalEmergencyPhone;
	/**
	 * 职业卫生负责人
	 */
    @ApiModelProperty(value="职业卫生负责人")
	private Long occLeaderSid;
	/**
	 * 职业卫生负责人联系电话
	 */
    @ApiModelProperty(value="职业卫生负责人联系电话")
	private String occLeaderTel;
	/**
	 * 用于演示环境可隐藏哪些部分的测试数据
	 */
    @ApiModelProperty(value="用于演示环境可隐藏哪些部分的测试数据")
	private Boolean superviseIsHide;
	/**
	 * 
	 */
    @ApiModelProperty(value="用于演示环境可隐藏哪些部分的测试数据")
	private Boolean superviseIsDel;
	/**
	 * 企业logo url 地址
	 */
    @ApiModelProperty(value="企业logo url 地址")
	private String logoFileUrl;
	/**
	 * 经营状态：存续，吊销
	 */
    @ApiModelProperty(value="经营状态：存续，吊销")
	private String operationStatus;
	/**
	 * 申报系统名称
	 */
    @ApiModelProperty(value="申报系统名称")
	private String reportCompanyName;
	/**
	 * 申报日期
	 */
    @ApiModelProperty(value="申报日期")
	private java.util.Date reportDate;
	/**
	 * 申报类型
	 */
    @ApiModelProperty(value="申报类型")
	private String reportType;
	/**
	 * 平台字段）注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构
	 */
    @ApiModelProperty(value="平台字段）注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构")
	private Integer regType;
	/**
	 * 平台字段）企业邮箱绑定状态(0-未绑定,1-已发送绑定信息,2-已绑定,3-超时)
	 */
    @ApiModelProperty(value="平台字段）企业邮箱绑定状态(0-未绑定,1-已发送绑定信息,2-已绑定,3-超时)")
	private Integer corpEmailCheck;
	/**
	 * 平台字段）企业编号串扩展(社会统一信代码/登记号/组织代码)
	 */
    @ApiModelProperty(value="平台字段）企业编号串扩展(社会统一信代码/登记号/组织代码)")
	private String corpCcExtend;
	/**
	 * 平台字段）审核结果(0-草稿,1-待审核,2-审核通过,3-审核不通过)
	 */
    @ApiModelProperty(value="平台字段）审核结果(0-草稿,1-待审核,2-审核通过,3-审核不通过)")
	private Integer checkState;
	/**
	 * 平台字段）审核时间
	 */
    @ApiModelProperty(value="平台字段）审核时间")
	private java.util.Date checkDate;
	/**
	 * 平台字段）申请人
	 */
    @ApiModelProperty(value="平台字段）申请人")
	private String corpApplyName;
	/**
	 * 平台字段）申请人手机号
	 */
    @ApiModelProperty(value="平台字段）申请人手机号")
	private String corpApplyMobile;
    
    /**
	 * 平台字段）证照照片
	 */
    @ApiModelProperty(value="平台字段）证照照片")
	private String corpFileUrl;
    
    /**
	 * 平台字段）头像id
	 */
    @ApiModelProperty(value="平台字段）头像id")
	private Long logoFileId;
	/**
	 * 平台字段）证照照片Id
	 */
    @ApiModelProperty(value="平台字段）证照照片Id")
	private Long corpFileId;
    
	
    /**
	 * 平台字段）注册/创建时间
	 */
    @ApiModelProperty(value="平台字段）注册/创建时间")
	private java.util.Date createDate;
}
