/**
 * 
 */
package cn.smarthse.modules.common.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 《2.1.3.	企业基础信息模型(CompanyModel)》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-12-21-上午10:03:44
 */
public @Data class CompanyModel  implements Serializable {
	private static final long serialVersionUID = 7670309119405331531L;

	/**
	 * 企业编号(软件的)
	 */
	private Long cid;
	
	/**
	 * 企业全称
	 */
	private String fullName;
	
	/**
	 * 企业简称
	 */
	private String shortName;
	
	/**
	 * 员工Id
	 */
	private Long staffId;
	
	/**
	 * 开始工作时间
	 */
	private Date startWorkDate;
	
	/**
	 * 结束工作时间,NULL表示至今
	 */
	private Date endWorkDate;
}
