/**
 * 
 */
package cn.smarthse.modules.common;

import java.util.Map;

/**
 * 《档案数据接口定义》
 * 职业卫生档案1-6号档案Service需要实现此接口
 * 辐射待订
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-8-25-上午10:19:32
 */
public interface IDocDataService {
	
	/**
	 * 获取档案数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-25-上午10:31:23
	 * @param cid									企业ID
	 * @param docParamValue				参数值(1:三同时项目ID,2-5为年份,6:员工IDS)
	 * @return
	 */
	Map<String, Object> getDocData(Long cid, String docParamValue);
	
	/**
	 * 获取档案自检数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-25-上午10:31:23
	 * @param cid									企业ID
	 * @param docParamValue				参数值(1:三同时项目ID,2-5为年份,6:员工IDS)
	 * @return
	 */
	Map<String, Object> getCheckData(Long cid, String docParamValue);
	
	/**
	 * 生成档案
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-8-上午11:26:17
	 * @param archiveTargetDir			档案生成目标
	 * @param docNo						档案编号
	 * @param cid								企业ID
	 * @param docParamValue			档案参数
	 * @return  数据包
	 * @exception		返回ServiceException表示生成失败
	 */
	Map<String, Object> generatorArchive(String archiveTargetDir,String docNo,Long cid, String docParamValue);

}
