package cn.smarthse.modules.platform.toC.model;

import java.io.Serializable;
import java.util.Date;

import cn.smarthse.modules.platform.model.UserCertificationModel;
import lombok.Data;
/**
 * 
 * 《第三方用户信息VO》
 * <li>该类专门为ToC应用需要获取平台用户绑定信息
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(ToC应用>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年3月8日-上午9:03:27
 */
public @Data class UserThirdModel implements Serializable {
	private static final long serialVersionUID = -5126793028019754385L;

	/**
     * 平台用户id
     */
    private Long userId;

    /**
     * 企业编号(企业用户时有值)
     */
    private Long cid;
    
    /**
     * 用户名
     */
    private String username;
    
    /**
     * 用户姓名(真实)
     */
    private String fullname;
    
    /**
     * 企业软件用户Token
     */
    private String softUserToken;
    
    /**
     * 手机号码
     * <li>平台绑定的手机号码
     */
    private String userMobile;
    
    /**
     * 用户邮箱
     * <li>平台绑定的邮箱
     */
    private String userEmail;


    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否关注第三方状态;
     */
    private int subscribe;
    
    /**
     * 第三方Token(QQ/微信/支付宝/微博等三方平台需要)
     */
    private String thirdToken;
    
    /**
     * 第三方昵称(QQ/微信/支付宝/微博等三方平台需要)
     */
    private String thirdNickname;

    /**
     * 第三方头像(QQ/微信/支付宝/微博等三方平台需要)
     */
    private String thirdFaceUrl;
    
    /**
     * 第三方类型
     */
    private UserThirdTypeEnum thirdType;
    
    /**
     * 平台实名认证信息
     */
    private UserCertificationModel userCertification;
}
