/**
 * 
 */
package cn.smarthse.modules.platform.toA.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 《代理商客户列表》
 * 企业名称	字符	龙泰科技	
	注册时间	日期	2017-9-12	注册成功时间，即后台审核确认的时间
	产品	字符	职业健康管理系统	
	产品有效期至	日期	2018-9-12	调取自客户订单中的产品有效期。未付款的订单，有效期显示“—”
	状态	字符	已付款	包括已付款和未付款
	订单提交时间	日期	2018-3-20	客户提交订单的时间
	付款金额（元）	数字	5000	未付款的金额显示“—”

 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年4月19日-上午9:26:39
 */
public @Data class CorpProductItemModel implements Serializable{
	private static final long serialVersionUID = 7695814583823154565L;
	/**
	 * 平台企业ID
	 */
	 private Long corpId;
	 
	/**
	 * 企业名称
	 */
	private String corpName;
	/**
	 * 注册时间
	 */
	private Date registerDate;
	
	/**
	 * 格式化数据
	 * 注册时间
	 */
	private String registerDateFormatter;
	/**
	 * 产品	
	 * <li>企业软件名称
	 */
	private String productName;
	/**
	 * 产品有效期至	调取自客户订单中的产品有效期。未付款的订单，有效期显示“—”
	 */
	private Date productValidityDate;
	/**
	 * 状态	包括已付款和未付款
	 * 处理状态（0-未付款，1-已付款，2-未收到金额，3-取消订单）
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.checkState
	 */
	private Byte payState;
	
	/**
	 * 软件类型(购买/试用/赠送)
	 * @see cn.smarthse.modules.platform.enums.CorpSoftLogTypeEnum
	 */
	private Byte softState;
	
	/**
	 * 订单支付时间
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.payUpdateDate
	 */
	private Date orderApplyDate;
	/**
	 * 付款金额（元）	未付款的金额显示“—”
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.payCost
	 */
	private BigDecimal payCost;
	
	/**
	 * 版本
	 */
	@Deprecated
	private String softVersionName;
	
	/**
	 * 套餐名
	 */
	private String comboName;
	
	/**
	 * 空间数:单位G
	 */
	private int spaceCount;
	
	/**
	 * 用户数:单位(个)
	 */
	private int userCount;
	
	/**
	 * 产品类
	 */
	private List<Product> product;
}
