package cn.smarthse.modules.platform.sys.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * 《系统参数表》
 * 
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-18-上午9:16:16
 */
@Table(name = "sys_param")
public @Data class SysParamModel implements Serializable {
	private static final long serialVersionUID = -6661191610982049064L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
    @ApiModelProperty(value="系统参数id")
    private Long id;

    /**
     * 父Id
     */
    @ApiModelProperty(value="系统参数父Id")
    @Column(name = "parent_id")
    private Long parentId;

    /**
     * 祖宗树
     */
    @ApiModelProperty(value="系统参数祖宗树Ids")
    @Column(name = "parent_ids")
    private String parentIds;

    /**
     * (参数分组，用于取所有数据）
     */
    @ApiModelProperty(value="参数分组")
    @Column(name = "param_group")
    private String paramGroup;

    /**
     * 参数编码
     */
    @ApiModelProperty(value="参数编码")
    @Column(name = "param_code")
    private String paramCode;

    /**
     * 参数值
     */
    @ApiModelProperty(value="参数值")
    @Column(name = "param_value")
    private String paramValue;

    /**
     * 参数描述
     */
    @ApiModelProperty(value="参数描述")
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @ApiModelProperty(value="是否有效", hidden=true)
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value="创建人Id", hidden=true)
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value="创建时间")
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value="最后修改人ID", hidden=true)
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value="修改时间")
    @Column(name = "update_date")
    private Date updateDate;

    
    //=====================TODO 数据属性 ============================
    /**
     * 所属行业L1
     */
    @Transient
    @ApiModelProperty(value="所属行业第一级Id")
    private SysParamModel corpTypeL1;
    
    /**
     * 所属行业L2
     */
    @Transient
    @ApiModelProperty(value="所属行业第二级Id")
    private SysParamModel corpTypeL2;
    
    /**
     * 所属行业L3
     */
    @Transient
    @ApiModelProperty(value="所属行业第三Id")
    private SysParamModel corpTypeL3;
}