package cn.smarthse.modules.platform.sys.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.modules.kafka.model.KafkaBaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * 《操作日志》
 * 
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-26-上午10:24:32
 */
@Table(name = "sys_log")
public @Data class SysLogModel extends KafkaBaseModel implements Serializable {
	private static final long serialVersionUID = -2798144642852401070L;

	/**
     * ID
     */
	@ApiModelProperty(value="创建时间")
    private Long id;

    /**
     * 企业编号
     */
	@ApiModelProperty(value="创建时间")
    private Long cid;

    /**
     * 企业软件编号
     */
	@ApiModelProperty(value="创建时间")
    private Long corpSoftId;
    
    /**
     * 操作账号(冗余)
     */
	@ApiModelProperty(value="创建时间")
    private String username;

    /**
     * 用户姓名(冗余)
     */
	@ApiModelProperty(value="创建时间")
    private String fullname;

    /**
     * 日志标题
     */
	@ApiModelProperty(value="创建时间")
    private String title;

    /**
     * 请求IP地址
     */
	@ApiModelProperty(value="创建时间")
    private String remoteIp;

    /**
     * 用户代理信息
     */
	@ApiModelProperty(value="创建时间")
    private String userAgent;

    /**
     * 请求URI
     */
	@ApiModelProperty(value="创建时间")
    private String requestUri;

    /**
     * 操作方式、post/get/push等resetful
     */
	@ApiModelProperty(value="创建时间")
    private String requestMethod;

    /**
     * 是否有效（0-无效，1-有效）
     */
	@ApiModelProperty(value="创建时间", hidden=true)
    private Boolean isValid;

    /**
     * 类型(0-异常日志,1-登录日志,2-操作日志）
     * @see cn.smarthse.modules.platform.core.framework.interceptor.log.LogConstans
     */
	@ApiModelProperty(value="创建时间")
    private Byte type;

    /**
     * 创建人
     */
    @ApiModelProperty(value="创建人Id", hidden=true)
    private Long createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value="创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value="最后修改人ID", hidden=true)
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value="创建时间")
    private Date updateDate;

    /**
     * 操作提交的数据内容(json)或者异常信息
     */
    @ApiModelProperty(value="创建时间")
    private String params;
    
    /**
	 * 来源模块
	 */
    @ApiModelProperty(value="创建时间")
	private String module;
	
	

}