/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;

import lombok.Data;

/**
 * 《用户认证模型》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月28日-上午8:53:23
 */
public @Data class UserCertificationModel implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 平台用户Id(发起认证接口时,必填)
	 */
	private Long userId;
	
	/**
     * 真实姓名
     */
    private String fullname;

    /**
     * 身份证号
     */
    private String cardNo;

    /**
     * 手持身份证正面照片
     */
    private Long cardPositiveFileId;
    
    /**
     * 手持身份证正面照片URL
     */
    private String cardPositiveFile;

    /**
     * 身份证背面照片
     */
    private Long cardBackFileId;
    
    /**
     * 身份证背面照片URL
     */
    private String cardBackFile;
	
    /**
     * 用户认证状态(0-未认证，1-待认证，2-已认证，3-认证不通过）
     * @see cn.smarthse.modules.platform.enums.UserCertificationCheckEnum
     */
    private Byte userCheckState; 
    
    /**
     * 审核结果说明
     */
    private String checkStateResult;
    
    /**
     * 审核时间
     */
    private Date checkStateDate;
}
