/**
 * 
 */
package cn.smarthse.modules.hospitaldevice.provider;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.common.IStaffInfoQueryService;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.hospitaldevice.model.HealthCheckModel;
import cn.smarthse.modules.hospitaldevice.model.MonitorModel;
import cn.smarthse.modules.hospitaldevice.model.TrainModel;

/**
 * 《3.4.	放射卫生&辐射安全管理系统微信接口定义》
 * <li>3.4.2.1.	体检信息列表接口
 * <li>3.4.3.	个人剂量检测接口
 * <li>3.4.4.	培训信息接口
 * <li>3.4.5.	合同告知接口
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-12-21-下午2:21:50
 */
public interface IHospitalDeviceStaffInfoQueryService extends
		IStaffInfoQueryService {
	
	/**
	 * 体检信息列表接口
	 * 用户身份证号,企业ID,开始年月日,结束年月日查询个人剂量检测列表
	 * <li>按时间倒序显示；
	 * @version:  V1.0
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-12-21-下午2:24:20
	 * @param paramModel	查询条件
	 * @return
	 */
	PageInfo<HealthCheckModel> getHealthCheckList(PageParamModel paramModel);
	
	/**
	 * 3.4.3.	个人剂量检测接口
	 * 用户身份证号,企业ID,开始年月日,结束年月日查询个人剂量检测列表
	 * <li>按时间倒序显示；
	 * 
	 * @version:  V1.0
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-12-21-下午2:26:55
	 * @param paramModel	查询条件
	 * @return
	 */
	PageInfo<MonitorModel> getMonitorList(PageParamModel paramModel);
	
	/**
	 * 3.4.4.	培训信息接口
	 * 用户身份证号,企业ID,开始年月日,结束年月日,培训类型查询个人培训列表
	 * <li>按时间倒序显示；
	 * 
	 * @version:  V1.0
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-12-21-下午2:28:31
	 * @param paramModel		查询条件
	 * @param trainType			培训类型，默认为0
	 * 							<li>0、全部类型培训
	 * 							<li>1、放射工作人员培训
	 * 							<li>2、辐射安全与防护培训
	 * @return
	 */
	PageInfo<TrainModel> getTrainList(PageParamModel paramModel, Integer trainType);
}
