/**
 * 
 */
package cn.smarthse.modules.health.provider;

import cn.smarthse.modules.platform.model.AdminSysLegal;

/**
 * 《软件2.0法律法规接口实现接口类》
 * 由软件2.0实现该接口文件,并注册到dobbo
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-25-上午9:17:59
 */
public interface IHealthSysLegalService {

	/**
	 * 添加法律法规(传入法律法规试用软件编号、AdminSysLegal)
	 * 
	 * @Comments:  <总后台添加法律法规同步到职业卫生>
	 * @author 徐颖东 [xyd.900919@qq.com]
	 * @since 2017-10-13-下午1:55:39
	 * @param corpmodel
	 */
	void addSysLegal(Integer legalTag, AdminSysLegal adminSysLegal);
	
	/**
	 * 编辑法律法规(传入法律法规试用软件编号、编辑前的法律法规名称、文号以及AdminSysLegal)
	 * 
	 * @Comments:  <总后台修改法律法规同步到职业卫生>
	 * @author 徐颖东 [xyd.900919@qq.com]
	 * @since 2017-10-13-下午1:55:39
	 * @param corpmodel
	 */
	void updateSysLegal(Integer legalTag, String title, String fileNo, AdminSysLegal adminSysLegal);
	
	/**
	 * 删除法律法规(传入AdminSysLegal)
	 * 
	 * @Comments:  <总后台删除法律法规同步到职业卫生>
	 * @author 徐颖东 [xyd.900919@qq.com]
	 * @since 2017-10-13-下午1:55:39
	 * @param corpmodel
	 */
	void delSysLegal(AdminSysLegal adminSysLegal);
}
