/**
 * 
 */
package cn.smarthse.modules.common.model;

import java.io.Serializable;
import java.util.Date;

import com.github.pagehelper.PageInfo;

import lombok.Data;

/**
 * 《2.1.2.	通用查询入参数模型》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-12-21-上午9:01:13
 */
public @Data class PageParamModel implements Serializable {
	private static final long serialVersionUID = 422489185277716398L;
	
	
	/**
	 * 身份证号
	 */
	private String idCard;
	/**
	 * 人员id
	 */
	private Long staffid;
	
	/**
	 * 企业ID,默认为NULL
	* <li>当企业ID为空时,查询人员所在当前企业；
	* <li>当企业ID=0时,查询人员的所有企业体检数据；
	* <li>当企业ID>0时,查询某企业体检数据
	 */
	private Long cid;
	
	/**
	 * 查询开始年月日,格式:YYYY-MM-DD
	 * <li>若为NULL,不设置为查询条件
	 */
	private Date startDate;
	
	/**
	 * 查询时间范围 ,结束年月日，格式(YYYY-MM-DD)
	 *  <li>若为NULL,不设置为查询条件
	 */
	private Date endDate;
	
	/**
	 * 分页信息，默认第1页,10条,若为NULL,则查询所有数据
	 */
	private PageInfo pageInfo;
	
}
