/**
 * 
 */
package cn.smarthse.modules.common;

import cn.smarthse.modules.platform.model.CorpInfoModel;
import cn.smarthse.modules.platform.model.CorpModel;
import cn.smarthse.modules.platform.model.CorpSoftModel;
import cn.smarthse.modules.platform.model.UserModel;

/**
 * 《平台与软件 接口定义》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-25-上午9:17:59
 */
public interface IShareCorpService {

	/**
	 * 企业注册并开通软件服务
	 * <li>实用于：购买,试用,运营后台处理线下购买开通接口
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-12-下午4:18:59
	 * @param corpmodel
	 */
	void regAndOpenCorp(CorpModel corpmodel);
	
	/**
	 * 更新为软件管理员(切换)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-12-下午4:45:32
	 * @param userModel 平台用户信息
	 */
	void updateUserManger(UserModel userModel);
	
	/**
	 * 添加/更新用户信息
	 * <li>包含md5(密码)时,需要变更密码
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-11-28-下午4:23:18
	 * @param userModel
	 */
	void updateUserInfo(UserModel userModel);
	
	/**
	 * 删除软件用户
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-12-下午4:48:33
	 * @param userModel 平台用户信息
	 */
	void deleteUser(UserModel userModel);
	
	/**
	 * 统计软件使用总空间数
	 * <li>返回G单位空间值
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-18-下午4:48:39
	 * @param corpSoft			企业软件信息
	 * @return
	 */
	float getSoftUsedSpace(CorpSoftModel corpSoft);
	
	
	/**
	 * 同步企业基础信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-10-13-上午10:50:27
	 * @param corpInfo
	 */
	void updateCorpInfo(CorpInfoModel corpInfo);
}
