/**
 * 
 */
package cn.smarthse.modules.platform.toA.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * 《代理商客户列表》中的产品列表
 * 企业名称	字符	龙泰科技	
	注册时间	日期	2017-9-12	注册成功时间，即后台审核确认的时间
	产品	字符	职业健康管理系统	
	产品有效期至	日期	2018-9-12	调取自客户订单中的产品有效期。未付款的订单，有效期显示“—”
	状态	字符	已付款	包括已付款和未付款
	订单提交时间	日期	2018-3-20	客户提交订单的时间
	付款金额（元）	数字	5000	未付款的金额显示“—”
 * @author cjy
 *@see 
 */
public @Data class Product implements Serializable{
	private static final long serialVersionUID = 7695814583823154566L;
	
	//productID: 1, productName: '职业健康管理系统' ,verson:"v1.0",space:"2G",num:"10" ,tj_time:"2018/02/12",state:"0" ,money:"152000",vld:"2020/02/12",cz:"这里写点击操作的方法"
	
	/**
	 * 产品	
	 * <li>企业软件名称
	 */
	private String productName;
	
	/**
	 * 付款金额（元）	未付款的金额显示“—”
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.payCost
	 */
	private BigDecimal payCost;
	
	/**
	 * 版本
	 */
	private String verson;
	
	/**
	 * 套餐名
	 */
	private String comboName;
	
	/**
	 * 空间数:单位G
	 */
	private int space;
	
	/**
	 * 用户数:单位(个)
	 */
	private int userCount;
	
	/**
	 * 订单支付时间
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.payUpdateDate
	 */
	private Date orderApplyDate;
	
	/**
	 * 格式化后数据
	 * 订单支付时间
	 * @see cn.smarthse.modules.platform.toA.model.Product.orderApplyDate
	 */
	private String orderApplyDateFormatter;
	
	/**
	 * 状态	包括已付款和未付款
	 * 处理状态（0-未付款，1-已付款，2-未收到金额，3-取消订单）
	 * @see cn.smarthse.modules.platform.entity.corp.CorpSoftPaylog.checkState
	 */
	private Byte payState;
	
	/**
	 * 支付状态说明
	 */
	private String payStateName;
	
	
	/**
	 * 软件类型(购买/试用/赠送)
	 * @see cn.smarthse.modules.platform.enums.CorpSoftLogTypeEnum
	 */
	private String softStateName;
	
	
	/**
	 * 产品有效期至	调取自客户订单中的产品有效期。未付款的订单，有效期显示“—”
	 */
	private Date productValidityDate;
	
	/**
	 * 格式化后数据
	 * 产品有效期至	调取自客户订单中的产品有效期。未付款的订单，有效期显示“—”
	 */
	private String productValidityDateFormatter;
	
	/**
	 * 操作类型(0-关闭，1-试用，2-购买，3-赠送）
	 * CorpProductItemModel
	 */
	private String typeName;
}

