/**
 * 
 */
package cn.smarthse.modules.platform.model.wechat.merchant;

import java.io.Serializable;

import lombok.Data;

/**
 * 《企业付款请求数据包》
 * 
 * 
 * @Project:  smarthse-framework-weixin
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月30日-下午3:23:58
 */
public @Data class TransfersRequestBody implements Serializable {
	private static final long serialVersionUID = -654505390386212528L;
	//"32位，，登录商户平台（账号格式为：129******@129******，密码通常六位）-》账户设置-》API安全-》设置API密钥";
	private String API_KEY;
	// 请求需要双向证书 P12文件目录
	private String SSLCERT_PATH;
	//	商户账号appid mch_appid 是 wx8888888888888888 String 申请商户号的appid或商户号绑定的appid 
	
	
	private String mch_appid;
//	商户号 mchid 是 1900000109 String(32) 微信支付分配的商户号 
	private String mchid;
//	设备号 device_info 否 013467007045764 String(32) 微信支付分配的终端设备号 
//	private String device_info;
//	随机字符串 nonce_str 是 5K8264ILTKCH16CQ2502SI8ZNMTM67VS String(32) 随机字符串，不长于32位 
	private String nonce_str;
//	签名 sign 是 C380BEC2BFD727A4B6845133519F3AD6 String(32) 签名，详见签名算法 
//	private String sign;
//	商户订单号 partner_trade_no 是 10000098201411111234567890 String 商户订单号，需保持唯一性(只能是字母或者数字，不能包含有符号) 
	private String partner_trade_no;
//	用户openid openid 是 oxTWIuGaIt6gTKsQRLau2M0yL16E String 商户appid下，某用户的openid 
	private String openid;
//	校验用户姓名选项 check_name 是 FORCE_CHECK String 
	//NO_CHECK：不校验真实姓名 
	//FORCE_CHECK：强校验真实姓名 
	private String check_name;
//	收款用户姓名 re_user_name 可选 王小王 String 收款用户真实姓名。 如果check_name设置为FORCE_CHECK，则必填用户真实姓名 
	private String re_user_name;
//	金额 amount 是 10099 int 企业付款金额，单位为分 
	private int amount;
//	企业付款描述信息 desc 是 理赔 String 企业付款操作说明信息。必填。 
	private String desc;
//	Ip地址 spbill_create_ip 是 192.168.0.1 String(32) 该IP同在商户平台设置的IP白名单中的IP没有关联，该IP可传用户端或者服务端的IP。 
	private String spbill_create_ip;

}
