/**
 * 
 */
package cn.smarthse.modules.platform.util;

import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

import org.apache.commons.codec.digest.DigestUtils;
import cn.smarthse.modules.platform.model.PayHeader;

/**
 * 《平台支付签名生成/检测 工具类》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月31日-上午9:58:18
 */
public class PaySignUtil {

	/**
	 * SUCCESS结果状态
	 */
	public static final String SUCCESS_CHAR="SUCCESS";
	/**
	 * 日期+小时+分
	 */
	public static final String yyyyMMddHHmm = "yyyyMMddHHmm";
	/**
	 * 日期+小时+分+秒
	 */
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
	
	/**
     * 生成PayHeader签名
     * 
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2018年5月31日-上午9:53:11
     * @param payHeader			签名头
     * @param API_KEY			签名密钥
     * @return
     */
    public static String buildPayHeaderSign(PayHeader payHeader, String API_KEY) {
    	TreeMap<String, Object> parms = new TreeMap<String, Object>();
    	parms.put("nonce_str", payHeader.getNonce_str());
    	parms.put("appid", payHeader.getAppid());
    	//TODO 增加其他参数
    	
    	//生成签名
		String sign = createSign(parms, API_KEY);
		//
		return sign;
	}
    
    /**
     * 验证PayHeader签名是否正确
     * @param payHeader			签名头
     * @param API_KEY			签名密钥
     * @return
     */
    public static boolean verifyPayHeaderSign(PayHeader payHeader, String key) {
        String createSign = buildPayHeaderSign(payHeader, key);  
        if(createSign.equals(payHeader.getSign())){  
            return true;  
        }else{  
            return false;  
        }  
    }
    
    
    /**
     * 生成签名
     * 
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2018年5月31日-上午9:53:11
     * @param packageParams		参数Map
     * @param key				签名密钥
     * @return
     */
    public static String createSign(SortedMap<String, Object> packageParams, String key) {
		StringBuffer sb = new StringBuffer();
		Set es = packageParams.entrySet();//字典序
		Iterator it = es.iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();
			String k = (String) entry.getKey();
			String v = (String) entry.getValue();
			//为空不参与签名、参数名区分大小写
			if (null != v && !"".equals(v) && !"sign".equals(k)
					&& !"key".equals(k)) {
				sb.append(k + "=" + v + "&");
			}
		}
		//第二步拼接key，key设置路径：微信商户平台(pay.weixin.qq.com)-->账户设置-->API安全-->密钥设置
		sb.append("key=").append(key);
//		System.out.println(">>>>>>>>>>>>>>>>>sb>>>>>>>>>>>>>>>>>>>");
//		System.out.println(sb.toString());
		String sign = DigestUtils.md5Hex(getContentBytes(sb.toString(), "UTF-8")); //MD5加密
		return sign;
	}
    
    /**
     * 验证签名是否正确
     * @param parameterMap	参数Map
     * @param key	签名密钥
     * @return
     */
    public static boolean verifySign(Map<Object, Object> map, String key) {
    	/**
    	 *  map:{transaction_id=4000692001201703011790249153, 
    	 *  nonce_str=tmWVt8Mp, 
    	 *  bank_type=CFT, 
    	 *  openid=oxxtKs76nPLZYnsfnLtJhb8midhk, 
    	 *  sign=AA4BEA78D65D4D8F2116B87963024C9B, 
    	 *  fee_type=CNY, 
    	 *  mch_id=1375193002, 
    	 *  cash_fee=1, 
    	 *  out_trade_no=s1c3t1488348062912, 
    	 *  appid=wxaaeb15e03b611a13, 
    	 *  total_fee=1, 
    	 *  trade_type=NATIVE, 
    	 *  result_code=SUCCESS, 
    	 *  time_end=20170301140113, 
    	 *  is_subscribe=N, 
    	 *  return_code=SUCCESS
    	 */
    	//重新生成验证参数
    	SortedMap<String, Object> parameterMap = new TreeMap<String, Object>();  
    	//同步回来的签名
        String sign = (String) map.get("sign");  
        for (Object keyValue : map.keySet()) {  
            if(!keyValue.toString().equals("sign")){  
                parameterMap.put(keyValue.toString(), map.get(keyValue));  
            }  
        }
        
        String createSign = createSign(parameterMap, key);  
        if(createSign.equals(sign)){  
            return true;  
        }else{  
            return false;  
        }  
    }
    
    /**
     * @param content
     * @param charset
     * @return
     * @throws SignatureException
     * @throws UnsupportedEncodingException 
     */
    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5签名过程中出现错误,指定的编码集不对,您目前指定的编码集是:" + charset);
        }
    }
    
    /**
     * 生成nonce_str
     * 
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2018年5月31日-上午11:05:05
     * @return
     */
    public static String create_nonce_str() {
    	// 随机数,18位日期yyyyMMddHHmmss
		String currTime = getStringDateTime(yyyyMMddHHmmss);
		// 四位随机数
		String strRandom =  String.valueOf(buildRandom(4));
	
		return currTime + strRandom;
    }
    
    /**
     * 获取当前时间字符
     * 
     * @return 字符串 根据dateFormat 格式返回
     */
    public static String getStringDateTime(String dateFormat){
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String dateString = formatter.format(currentTime);
        return dateString;
    }
    
    /**
	 * 取出一个指定长度大小的随机正整数.
	 * 
	 * @param length  int 设定所取出随机数的长度。length小于11
	 * @return int 返回生成的随机数。
	 */
	public static int buildRandom(int length) {
		int num = 1;
		double random = Math.random();
		if (random < 0.1) {
			random = random + 0.1;
		}
		for (int i = 0; i < length; i++) {
			num = num * 10;
		}
		return (int) ((random * num));
	}

    /**
     * 生成系统 时间搓
     * 
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2018年5月31日-上午11:05:14
     * @return
     */
    public static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000);
    }
}
