/**
 * 
 */
package cn.smarthse.modules.platform.provider;

import java.util.Date;
import java.util.List;

import cn.smarthse.common.framework.tencent.weixin.vo.WxReturnJson;
import cn.smarthse.common.framework.tencent.weixin.vo.WxTemplateResult;
import cn.smarthse.modules.platform.model.wechat.HealthReportTemplateModel;

/**
 * 《平台公共微信推送2.3接口》
 * <p>引用方法@Reference(version="2.3.0")</p>
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年6月19日-下午2:45:53
 */
public interface IWechat23Service extends IWechatService{

	/**
	 * 增加发送微信消息定时任务
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月19日-下午2:53:10
	 * @param userList		发送人员列表
	 * @param content		发送内容
	 * @param jumpUrl		内容对接连接地址
	 * @param sendDate		发送定时时间
	 * @return
	 */
	public int addTask(List<Long> userList,  String content, String jumpUrl, Date sendDate);
	
	/**
	 * 发送体检报告
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年8月6日-下午4:47:35
	 * @param reportTemplateModel	
	 * @return
	 */
	public WxTemplateResult sendTemlateByHealthReport(HealthReportTemplateModel reportTemplateModel );
}
