/**
 * 
 */
package cn.smarthse.modules.platform.enums;

/**
 * 《软件状态定义》
 * 
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-22-下午3:51:18
 */
public enum SoftCheckEnum {
	/**
	 * 待处理
	 */
	checking("待处理", (byte) 0),
	/**
	 * 已处理
	 */
	check_yes("通过", (byte) 1),
	/**
	 * 已拒绝
	 */
	check_no("不通过", (byte) 2);

	// 成员变量
	private Byte state;
	private String value;

	// 构造方法
	private SoftCheckEnum(String value, Byte state) {
		this.state = state;
		this.value = value;
	}

	// 普通方法
	public static SoftCheckEnum get(Byte state) {
		if (state == null) {
			return null;
		}
		for (SoftCheckEnum c : SoftCheckEnum.values()) {
			if (c.getState().equals(state)) {
				return c;
			}
		}
		return null;
	}
	
	// get set 方法

	/**
	 * @return the state
	 */
	public Byte getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Byte state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
}
