package cn.smarthse.modules.healthadvisor.enums;

/**
 * 健康券来源
 * @author gbx
 */
public enum TicketSourceEnum {
	
	/**
	 * 企业号分配
	 */
	corp("企业号分配", (byte) 1),
	
	/**
	 * 平台赠送
	 */
	www("平台赠送", (byte) 2),
	
	/**
	 * 活动赠送
	 */
	party1("2018年6月19活动赠送", (byte) 8);

	// 成员变量
	private Byte state;
	private String value;

	// 构造方法
	private TicketSourceEnum(String value, Byte state) {
		this.state = state;
		this.value = value;
	}

	// get set 方法

	/**
	 * @return the state
	 */
	public Byte getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Byte state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	// 普通方法
	public static String getValue(Integer state) {
		if (state == null) {
			return null;
		}
		for (TicketSourceEnum c : TicketSourceEnum.values()) {
			if (c.getState().equals(state)) {
				return c.value;
			}
		}
		return null;
	}
}
