package cn.smarthse.modules.health.provider;


import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.health.model.*;

import java.util.Date;
import java.util.List;

import com.github.pagehelper.PageInfo;

/**
 * 《3.4.	职业健康管理系统微信接口定义》
 * <li>3.3.1.	人员查询历史企业列表
 * <li>3.3.2.	合同告知信息列表接口
 * <li>3.3.2.1.	 合同详细信息接口
 * <li>3.3.3.	体检信息列表接口
 * <li>3.3.3.1.	 体检详细信息接口
 * <li>3.3.4.	培训信息列表接口
 * <li>3.3.5.	个人防护用品信息列表接口
 * <li>3.3.5.1.	个人防护用品详细信息接口
 *
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author Join(黄敬良)
 * @since 2017-12-25-下午9:21:50
 */
public interface IHealthStaffInfoQueryService {

    /**
     * 获取合同告知列表
     * 用户身份证号,企业ID,开始年月日,结束年月日查询个人合同告知列表
     * <li>按时间倒序显示；
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param paramModel	查询条件
     * @return
     */
    List<HContractInfoModel> getContractInfoList(PageParamModel paramModel);
    
    /**
     * 获取合同告知列表 分页
     * 
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-12-26-下午2:54:11
     * @param paramModel
     * @return
     */
    PageInfo<HContractInfoModel> getContractInfoPage(PageParamModel paramModel);
    
    
    /**
     * 根据id查询合同告知
     * @param contractId
     * @return
     */
    HContractInfoModel getContractInfoById(Long contractId);
    
    /**
     * 获取合同告知的危害因素信息
     * 用户身份证号,企业ID,查询个人合同告知的危害因素信息
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param contractInfoId	合同告知id
     * @return
     */
    HContractInfoOccModel getContractInfoOcc(Long contractInfoId);
    
    
    /**
     *  获取合同告知的危害因素信息列表
     * @param contractInfoId 合同告知id
     * @return
     */
    List<HContractInfoOccModel> getContractInfoOccByContractInfoId(Long contractInfoId);
    
    /**
     * 获取体检信息列表
     * 用户身份证号,企业ID,年月 查询体检信息
     * <li>按时间倒序显示；
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param paramModel	查询条件
     * @return
     */
    List<HHealthCheckModel> getHealthCheckList(PageParamModel paramModel);

    /**
     * 获取体检信息列表(分页)
     * 用户身份证号,企业ID,年月 查询体检信息
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-12-26-下午2:56:48
     * @param paramModel
     * @return
     */
    PageInfo<HHealthCheckModel> getHealthCheckPage(PageParamModel paramModel);
    
    /**
     * 获取体检异常信息
     * 根据体检信息id查询体检危害因素信息
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param healthCheckId	 体检信息id
     * @param StaffId	 员工id
     * @param checkType 体检类型
     * @return
     */
    HHealthCheckModel getHealthConclusion(Long healthCheckId, Long StaffId,String checkType);

    /**
     * 获取培训信息列表
     * 用户身份证号,企业ID,年份 查询培训信息
     * <li>按时间倒序显示；
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param paramModel	查询条件
     * @return
     */
    List<HTrainingModel> getTrainingList(PageParamModel paramModel);

    /**
     * 获取培训信息列表(分页)
     * 用户身份证号,企业ID,年份 查询培训信息
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-12-26-下午2:57:57
     * @param paramModel
     * @return
     */
    PageInfo<HTrainingModel> getTrainingPage(PageParamModel paramModel);
    
    /**
     * 获取检测信息列表
     * 用户身份证号,企业ID,年份 查询培训信息
     * <li>按时间倒序显示；
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param paramModel	查询条件
     * @return
     */
    List<HDetectionModel> getDetectionList(PageParamModel paramModel);

    /**
     * 获取检测信息列表(分页)
     * 用户身份证号,企业ID,年份 查询培训信息
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-12-26-下午2:58:36
     * @param paramModel
     * @return
     */
    PageInfo<HDetectionModel> getDetectionPage(PageParamModel paramModel);
    
    /**
     * 获取检测到的危害因素
     * 根据岗位工种id查询岗位危害因素信息
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param workRoleId	 岗位工种id
     * @param occName	    危害因素名称
     * @param isExceeded	是否超标 false:查询全部（不管是否超标） true:只查询超标的
     * @param workRoleStartDate 岗位开始时间
     * @param workRoleendDate 岗位结束时间
     * @return
     */
    List<HDetectionOccModel> getDetectionOccList(Long workRoleId,String occName, boolean isExceeded,Date workRoleStartDate,Date workRoleendDate,Boolean isPartTime);

    /**
     * 获取个人所有工作过的岗位工种列表(分页)
     * 用户身份证号,企业ID,年份 查询岗位工种列表
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-12-26-下午3:00:24
     * @param paramModel
     * @return
     */
    PageInfo<HistoryWorkRoleModel> getHistoryWorkRolePage(PageParamModel paramModel);
    
    /**
     * 获取个人防护用品明细信息
     * 根据岗位工种id查询岗位对应个人防护用品明细信息
     * @version:  V1.0
     * @author Join(黄敬良)
     * @since 2017-12-25-下午9:21:50
     * @param workRoleId	 岗位工种id
     * @return
     */
    PageInfo<HProEquipmentDetailModel> getProEquipmentDetail(Long workRoleId,PageInfo pageInfo);
    
    /**
     * 查询历史单位
     * @param idCard 身份证号
     * @return
     */
    List<HistoryCompanyModel> getHistoryCompanyListByUser(String idCard);
    
    /**
    * @Comments:  <App合同告知接口>
    * @author gbx
    * @since 2017-12-26-下午2:54:11
    * @param paramModel.cid 0 所有的
    * @return
    */
   PageInfo<HContractInfoModel> getContractInfoAppPage(PageParamModel paramModel);
    
}
