package cn.smarthse.modules.common.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 
 * 《ActiveCompany》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:
 * @Comments:  <活跃企业>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2018-1-02-上午10:13:09
 */
public @Data class ActiveCompany implements Serializable {
    
	/**
     * 企业ID(平台企业ID)
     */
    private Long cid;
    
    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 行政区划ID
     */
    private Long areaId;

    /**
     * 行政区划名称
     */
    private String areaName;

    /**
     * 软件开通时间
     */
    private Date startDate;

    /**
     * 使用空间数
     */
    private Long spaceUsedCount;
    
    /**
     * 登录次数
     */
    private Integer loginTotal;

    /**
     * 操作模块数量
     */
    private Integer moduleSize;

    /**
     * 操作模块信息
     */
    private List<ModuleInformation> moduleList;

    private static final long serialVersionUID = 1L;
}