package cn.smarthse.modules.platform.toC.provider;

import cn.smarthse.modules.platform.toC.model.UserThirdModel;
import cn.smarthse.modules.platform.toC.model.UserThirdTypeEnum;

/**
 * 
 * 《平台用户第三方信息接口声明》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年3月8日-上午10:05:08
 */
public interface IUserThirdService {

	/**
	 * 根据OpenId读取用户绑定信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年3月8日-上午10:06:36
	 * @param OpenId	微信绑定Token
	 * @return
	 * @exception		ServiceException 异常
	 */
	UserThirdModel getUserThirdByToken(String OpenId);
	
	/**
	 * 根据用户Id与第三方类型获取Token
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年3月21日-下午4:06:30
	 * @param userId			平台用户Id
	 * @param thirdType			第三方类型枚举类
	 * @return
	 */
	String getUserThirdToken(Long userId, UserThirdTypeEnum thirdType);

	
	/**
	 * 绑定融云平台
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年3月21日-下午5:02:02
	 * @param userId		平台用户 Id，最大长度 64 字节。是用户在 App 中的唯一标识码，必须保证在同一个 App 内不重复，重复的用户 Id 将被当作是同一用户。（必传）
	 * @param name			用户名称，最大长度 128 字节。用来在 Push 推送时显示用户的名称。（必传）
	 * @param portraitUri	用户头像 URI，最大长度 1024 字节。（必传）
	 * @return	
	 * 	<li>code	Int	返回码，200 为正常。如果您正在使用开发环境的 AppKey，您的应用只能注册 100 名用户，达到上限后，将返回错误码 2007。如果您需要更多的测试账户数量，您需要在应用配置中申请“增加测试人数”。
	 * 	<li>token	String	用户 Token，可以保存应用内，长度在 256 字节以内。
	 * 	<li>userId	String	用户 Id，与输入的用户 Id 相同。
	 */
	String bindRongCloudUser(Long userId, String name, String portraitUri);
	
	/**
	 * 查询OpenId对应的微信信息JSON
	 * <li>JSON对应数据 包：cn.smarthse.common.framework.tencent.weixin.vo.UserUnionInfo
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月13日-上午8:54:26
	 * @param openId
	 * @return
	 */
	String getWeixinUserInfo(String openId);
	
}
