/**
 * 
 */
package cn.smarthse.modules.platform.toA.provider;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.platform.model.CorpInfoModel;
import cn.smarthse.modules.platform.toA.model.AgentBalanceGroup;
import cn.smarthse.modules.platform.toA.model.AgentBalanceGroupItem;
import cn.smarthse.modules.platform.toA.model.AgentCorpSeachModel;
import cn.smarthse.modules.platform.toA.model.CorpProductItemModel;

/**
 * 《代理商客户Service接口声明》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年4月19日-上午9:53:22
 */
public interface IAgentCorpService {
	
	/**
	 * 根据 promoteCode 分组查询业务员/代理商 balanceYear 年份结算表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月29日-下午1:54:04
	 * @param promoteCode		业务员/代理商推广码
	 * @param balanceYear		分组查询年份
	 * @return
	 */
	List<AgentBalanceGroup> getGroupByAgent(String promoteCode, int balanceYear);
	
	
	/**
	 * 根据 promoteCode 分组查询业务员/代理商 balanceIssuea期号结算详情
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月29日-下午2:39:23
	 * @param promoteCode
	 * @param balanceIssue
	 * @return
	 */
	List<AgentBalanceGroupItem> getGroupItemByAgent(String promoteCode, String balanceIssue);
	
	/**
	 * 根据推广码s查询客户列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年4月19日-上午9:57:36
	 * @param promocodes	多个推广码,以逗号隔开
	 * @return
	 */
	PageInfo<CorpProductItemModel> getCorpInfoModelByAgent(AgentCorpSeachModel model);
	
	/**
	 * 根据平台Cid查询企业详情
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年4月19日-上午11:07:19
	 * @param cid
	 * @return
	 */
	CorpInfoModel getCorpInfoModelByCid(Long cid);
	
	/**
	 * 根据企业Id查询订单列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年4月19日-下午2:34:00
	 * @param cid			企业Id
	 * @param pageIndex		页码
	 * @param pageIndex		页数量
	 * 
	 * @return
	 */
	PageInfo<CorpProductItemModel> getCorpSoftModelListByCid(Long cid, int pageIndex, int pageSize);
	
	/**
	 * 根据代理商推广码和企业Id查询客户软件记录
	 * 
	 *  @date 2018年7月9日
	 *	@author cjy
	 *  @param cid        企业Id
	 *  @param promCode   代理商的推广码
	 *  @param pageIndex  页码
	 *  @param pageSize   页数
	 *  @return
	 */
	PageInfo<CorpProductItemModel> getCorpSoftModelListByCidAndPromCode(Long cid, String promCode,int pageIndex, int pageSize);
	
}
