package cn.smarthse.modules.platform.sys.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

@Table(name = "sys_file")
public @Data class SysFile implements Serializable {
    /**
     * ID
     */
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
    private Long id;

    /**
     * OSS路径地址（相对）
     */
    private String ossUrl;

    /**
     * 附件名
     */
    private String fileName;

    /**
     * 附件大小
     */
    private String fileSize;

    /**
     * 附件扩展名（可用于图标展示）
     */
    private String fileExt;

    /**
     * 附件Hash
     */
    private String fileHash;

    /**
     * 上传IP
     */
    private String creatorIp;

    /**
     * 附件描述
     */
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取OSS路径地址（相对）
     *
     * @return oss_url - OSS路径地址（相对）
     */
    public String getOssUrl() {
        return ossUrl;
    }

    /**
     * 设置OSS路径地址（相对）
     *
     * @param ossUrl OSS路径地址（相对）
     */
    public void setOssUrl(String ossUrl) {
        this.ossUrl = ossUrl == null ? null : ossUrl.trim();
    }

    /**
     * 获取附件名
     *
     * @return file_name - 附件名
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * 设置附件名
     *
     * @param fileName 附件名
     */
    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    /**
     * 获取附件大小
     *
     * @return file_size - 附件大小
     */
    public String getFileSize() {
        return fileSize;
    }

    /**
     * 设置附件大小
     *
     * @param fileSize 附件大小
     */
    public void setFileSize(String fileSize) {
        this.fileSize = fileSize == null ? null : fileSize.trim();
    }

    /**
     * 获取附件扩展名（可用于图标展示）
     *
     * @return file_ext - 附件扩展名（可用于图标展示）
     */
    public String getFileExt() {
        return fileExt;
    }

    /**
     * 设置附件扩展名（可用于图标展示）
     *
     * @param fileExt 附件扩展名（可用于图标展示）
     */
    public void setFileExt(String fileExt) {
        this.fileExt = fileExt == null ? null : fileExt.trim();
    }

    /**
     * 获取附件Hash
     *
     * @return file_hash - 附件Hash
     */
    public String getFileHash() {
        return fileHash;
    }

    /**
     * 设置附件Hash
     *
     * @param fileHash 附件Hash
     */
    public void setFileHash(String fileHash) {
        this.fileHash = fileHash == null ? null : fileHash.trim();
    }

    /**
     * 获取上传IP
     *
     * @return creator_ip - 上传IP
     */
    public String getCreatorIp() {
        return creatorIp;
    }

    /**
     * 设置上传IP
     *
     * @param creatorIp 上传IP
     */
    public void setCreatorIp(String creatorIp) {
        this.creatorIp = creatorIp == null ? null : creatorIp.trim();
    }

    /**
     * 获取附件描述
     *
     * @return description - 附件描述
     */
    public String getDescription() {
        return description;
    }

    /**
     * 设置附件描述
     *
     * @param description 附件描述
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}