/**
 * 
 */
package cn.smarthse.modules.platform.provider;


import cn.smarthse.modules.platform.model.UserCertificationModel;
import cn.smarthse.modules.platform.model.UserModel;
import cn.smarthse.modules.platform.toC.model.UserThirdModel;

/**
 * 《平台用户接口》
 * 
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午3:30:20
 */
public interface IPUserService {

	/**
	 * 注册平台账号
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月4日-上午8:28:58
	 * @param model
	 * @return	平台用户Id
	 */
	Long registerUser(UserModel model);
	
	/**
	 * 第三方用户注册
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午3:52:06
	 * @param model			注册数据
	 * @param userThird			第三方数据包
	 * @return	Long			平台用户Id
	 */
	Long registeredByThird(UserModel model, UserThirdModel userThird);
	
	/**
	 * 根据Key查询用户基础信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午9:28:43
	 * @param key
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModelBase(String key) ;
	
	/**
	 * 根据Key查询用户信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月11日-上午9:59:14
	 * @param key	用户名,手机,邮箱,openid,等第三方绑定表的token
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModel(String key);
	
	/**
	 * 根据Key查询用户信息
	 * <li> 2018/05/28 增加获取用户信息时,读取包含用户个人认证数据接口 edit by shao TO 健康顾问2.2
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月11日-上午9:59:14
	 * @param key	用户名,手机,邮箱,openid,等第三方绑定表的token
	 * @return
	 * @throws ServiceException
	 */
	UserModel getUserModelWithUserCertification(String key);
	
	/**
	 * 处理用户绑定
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午4:20:20
	 * @param userThird
	 * @return	Integer		
	 */
	Integer processUserBindLogin(UserThirdModel userThird);
	
	/**
	 * 处理用户提交实名认证信息
	 * <li>平台已有提交信息时,ServiceException异常,C端自己处理
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午9:46:31
	 * @param certificationModel	认证信息
	 * @return	<li>0: 	未成功提交认证信息,可能平台有个人认证处理
	 * 			<li>1:	成功提交
	 * @throws ServiceException
	 */
	Integer processUserCertification(UserCertificationModel certificationModel) ;
	
	/**
	 * 根据平台Id查询平台认证信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月28日-上午11:35:59
	 * @param userId
	 * @return	null:表示无认证信息(未认证)
	 */
	UserCertificationModel getUserCertificationModelByUserId(Long userId);
	
	
	/**
	 * 验证用户名与密码是否正确
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月6日-下午2:11:33
	 * @param username		用户名
	 * @param md5password	密码(md5)
	 * @return
	 */
	Boolean verifyPassword(String username, String md5password);
	
}
