/**
 * 
 */
package cn.smarthse.modules.platform.provider;

import java.util.List;


import cn.smarthse.modules.platform.model.AreaModel;


/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月4日-上午8:47:55
 */
public interface IPAreaService {
	/**
	 * 根据行政区域编号查询(12位)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月4日-上午10:49:55
	 * @param id
	 * @return
	 */
	AreaModel getById(Long id);
	
	/**
	 * id1,id2,id3
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月4日-上午10:51:39
	 * @param ids
	 * @return
	 */
	List<AreaModel> getListByIds(String ids);
	
	/**
	 * 根据Ids查询返回全路径信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月22日-上午10:53:09
	 * @param ids
	 * @return
	 */
	String getListFullnameByIds(String ids);
	
	/**
	 * 根据Ids查询返回短名信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月22日-上午10:53:26
	 * @param ids
	 * @return
	 */
	String getListShortnameByIds(String ids);
	
	/**
	 * 读取中国全省列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午2:03:05
	 * @return
	 */
	List<AreaModel> getAllProvinceList();

	/**
	 * 根据省ID读取全市列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午2:03:20
	 * @param provinceId	省份编号
	 * @return
	 */
	List<AreaModel> getCityList(Long provinceId);

	/**
	 * 根据市ID读取全区列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午2:03:34
	 * @param cityId	城市编号
	 * @return
	 */
	List<AreaModel> getAreaList(Long cityId);

	/**
	 * 根据区域ID读取全街道列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午2:03:53
	 * @param areaId		区域编号
	 * @return
	 */
	List<AreaModel> getStreetList(Long areaId);
	

	/**
	 * 根据区域ID子列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午2:03:53
	 * @param pid		父类编号
	 * @return
	 */
	List<AreaModel> getChildByPid(Long pid);
	
	/**
	 * 根据区域ID子列表的数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-17-下午2:03:53
	 * @param pid		父类编号
	 * @return
	 */
	int countChildByPid(Long pid);
}
