/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.io.Serializable;

import lombok.Data;

/**
 * 《软件/平台 用户信息实体信息定义》
 * 
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午3:20:47
 */
public @Data class UserModel implements Serializable {
	private static final long serialVersionUID = -9005315054164430440L;

	/**
	 * 平台企业ID
	 */
	 private Long corpId;
	 
	/**
	 * 企业软件ID
	 */
	private Long corpSoftId;
	
	/**
	 * 平台用户唯一标识号
	 */
	private String usertoken;
	
	/**
	 * 登录账号Id
	 */
	private Long userId;
	
	/**
	 * 登录账号
	 */
	private String username;
	
	/**
	 * 登录密码(MD5(明文))
	 * 密码为NULL时,表示不变更现在账号的密码
	 */
	private String password;
	
	  /**
     * 用户姓名
     */
    private String fullname;
    
    /**
     * 绑定的手机
     */
    private String mobile;
    
    /**
     * 绑定的邮箱
     */
    private String email;
    
    /**
     * 设定为管理员
     */
    private Boolean isManger;
    
    /**
     * 注册来源
     */
    private String regResource;
    
    /**
     * 实名认证信息
     */
    private UserCertificationModel userCertification;
}
