/**
 * 
 */
package cn.smarthse.modules.platform.enums;

/**
 * 《价格类型定义》
 * 价格类型(0-按年,1-按月,2-按季,3-按周,4-按日)
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-27-下午3:32:20
 */
public enum PriceTypeEnum {
	/**
	 * 按年
	 */
	year("按年", (byte) 0),
	/**
	 * 按月
	 */
	month("按月", (byte) 1),
	/**
	 * 按季
	 */
	quarter("按季", (byte) 2),
	/**
	 * 按周
	 */
	week("按周", (byte) 3),
	/**
	 * 按日
	 */
	day("按日", (byte) 4),
	;
	

	// 成员变量
	private Byte state;
	private String value;

	// 构造方法
	private PriceTypeEnum(String value, Byte state) {
		this.state = state;
		this.value = value;
	}

	// get set 方法

	/**
	 * @return the state
	 */
	public Byte getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Byte state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
}
