package cn.smarthse.modules.healthadvisor.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 
 * 《UserTicket》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:
 * @Comments:  <用户健康券分配>
 * @JDK version used:      <JDK1.8> 
 * @author gbx
 * @since 2018-1-02-上午10:13:09
 */
public @Data class UserTicket implements Serializable {
	
	/**
	 * 企业id
	 */
	private Long cid;
	
	/**
	 * 平台用户id
	 */
	private Long userId;
	
	/**
	 * 到期时间
	 */
	private Date edate;
	
	/**
	 * 在线-健康券id
	 */
	private Long onlineId;
	
	/**
	 * 分配的在线-健康券数量
	 */
	private Integer onlineNum;
	
	/**
	 * 电话-健康券id
	 */
	private Long telephoneId;
	
	/**
	 * 分配的电话-健康券数量
	 */
	private Integer telephoneNum;
	
	/**
	 * 问诊-健康券id
	 */
	private Long inquisitionId;
	
	/**
	 * 分配的问诊-健康券数量
	 */
	private Integer inquisitionNum;
	
	/**
	 * 手术-健康券id
	 */
	private Long operationId;
	
	/**
	 * 分配的手术-健康券数量
	 */
	private Integer operationNum;
	
	/**
	 * 住院-健康券id
	 */
	private Long hospitalizationId;
	
	/**
	 * 分配的住院-健康券数量
	 */
	private Integer hospitalizationNum;
	
	
	/**
	 * 用户登陆账号
	 */
	private String username;
	
	/**
	 * 姓名
	 */
	private String name;
	
	
	/**
	 * 操作时间
	 */
	private Date operationDate;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    
	
}