/**
 * 
 */
package cn.smarthse.modules.platform.model;

import java.io.Serializable;
import java.math.BigDecimal;


import lombok.Data;

/**
 * 《软件版本信息》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月22日-下午1:35:58
 */
public @Data class SoftVersionModel implements Serializable {
	private static final long serialVersionUID = 3756405717322857249L;

	/**
	 * 版本编号
	 */
	private Long softVersionId;
	
	 /**
     * 版本设定编号
     */
    private String softVersionNo;

    /**
     * 版本名
     */
    private String softVersionName;

    /**
     * 版本价格
     */
    private BigDecimal softSell;

    /**
     * 版本试用时间
     */
    private Integer softTryDays;

    /**
     * 价格类型(0-按年,1-按月,2-按季,3-按周,4-按日)
     */
    private Byte priceType;
	
}
