/**
 * 
 */
package cn.smarthse.modules.hospitaldevice.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 《2.4.3.	培训模型(TrainModel)》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-12-21-下午2:07:18
 */
public @Data class TrainModel implements Serializable {
	private static final long serialVersionUID = -7983228874427786621L;
	
	/**
	 * 开始年月	String	格式(YYYY-MM-DD)
	 */
	private Date startDate;
	
	/**
	 * 结束年月	String	格式(YYYY-MM-DD),无则显示“至今”
	 */
	private Date endDate;
	
	/**
	 * 培训类型	Integer	培训类型：
	 * <li>1、放射工作人员培训
	 * <li>2、辐射安全与防护培训
	 */
	
	private Integer trainType;
	
	/**
	 * 培训等级	String	培训等级：初级、中级、高级
	 */
	private String trainlevelName;
	
	/**
	 * 培训性质	String	培训性质：初训、复训
	 */
	private String trainNature;
	
	/**
	 * 培训机构	String	
	 */
	private String trainCompanyName;
    //考核结果 0：不合格 1：合格
    private Byte checkresult;
    
    /**
	 * 开始时间
	 */
	private String start = "";
	
	/**
	 * 结束时间
	 */
	private String end = "";

}
