/**
 * 
 */
package cn.smarthse.modules.healthadvisor.model;


import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Data;

/**
 * 《医生数据实体》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年5月3日-下午4:30:27
 */
public @Data class DoctorUserModel implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Long id;

	/**
     * 当前登录人
     */
    private Long adminId;

    //TODO  HaUser实体
    
    /**
     * 平台用户编号
     */
    private Long userId;
    
    /**
     * 头像文件编号（file.id)
     */
    private Long faceId;
    
    /**
     * 姓名
     */
    private String fullname;
	
	/**
     * 绑定手机（绑定后，修改需要重新绑定后才可修改）
     */
    private String userMobile;
    
    //TODO  HaDoctorInfo实体 ha_doctor_check
    
    /**
     * 医生来源(0-系统医生，1-注册医生）
     */
    private Byte regSource;
    
    /**
     * 职称
     */
    private String jobTitle;
   
    /**
     * 医院名称
     */
    private String hospitalName;
   
    /**
     * 科室名称
     */
    private String departmentsName;
    
    /**
	 * <li>1.3每月基础服务订单数
	 */
	private Integer baseServiceCount;
   
    /**
     * 所在地
     */
    private Long areaId;
   
    /**
     * 是否推荐
     */
    private Boolean isRecommend;
   
    /**
     * 擅长
     */
    private String goodAt;
    
    /**
     * 擅长项
     */
    private String goodAtValue;

    /**
     * 医学教育背景介绍
     */
    private String medicineEduInfo;
    
    /**
     * 医生认证状态(0-未认证，1-待认证，2-已认证，3-认证不通过）
     */
    private Byte checkState;

    /**
     * 擅长输入字符串
     */
    private String doctorGoodAtText;
   
    //TODO  HaDoctorServiceConfig实体
   
    /**
     * 电话服务上午是否服务
     */
    private Boolean isTelServiceMorning;
   
    /**
     * 电话服务上午服务费用
     */
    private Integer telServiceMorningFee;
   
    /**
     * 电话服务下午是否服务
     */
    private Boolean isTelServiceAfternoon;
   
    /**
     * 电话服务下午服务费用
     */
    private Integer telServiceAfternoonFee;
   
    /**
     * 电话服务晚上是否服务
     */
    private Boolean isTelServiceNight;
   
    /**
     * 电话服务晚上服务费用
     */
    private Integer telServiceNightFee;
   
    /**
     * 在线咨询上午是否服务
     */
    private Boolean isNetServiceMorning;

    /**
     * 在线咨询上午服务费用
     */
    private Integer netServiceMorningFee;
   
    /**
     * 在线咨询下午是否服务
     */
    private Boolean isNetServiceAfternoon;
   
    /**
     * 在线咨询下午服务费用
     */
    private Integer netServiceAfternoonFee;
   
    /**
     * 在线咨询晚上是否服务
     */
    private Boolean isNetServiceNight;
   
    /**
     * 在线咨询晚上服务费用
     */
    private Integer netServiceNightFee;
   
    //TODO  HaDoctorBonus实体 
   
    /**
     * 电话服务分成比例
     */
    private BigDecimal telMoney;
   
    /**
     * 电话服务健康劵分成
     */
    private BigDecimal telVoucher;
   
    /**
     * 在线咨询分成比例
     */
    private BigDecimal netMoney;
   
    /**
     * 在线咨询健康劵分成
     */
    private BigDecimal netVoucher;
   
    //TODO  HaDoctorCheck实体 
   
    /**
     * 证件号码
     */
    private String certNo;

    /**
     * 身份证正面图Id
     */
    private Long certFrontId;

    /**
     * 身份证反面图Id
     */
    private Long certBackId;

    /**
     * 医师执业证Id
     */
    private Long certPracticingLicenseId;

    /**
     * 医师资格证Id
     */
    private Long certDoctorLicenseId;

    /**
     * 专业技术资格证Id
     */
    private Long certProfTechnicalLicenseId;
    
    /**
     * 审核说明
     */
    private String checkStateResult;
   
}
