package cn.smarthse.modules.healthadvisor.enums;

/**
 * @author gbx
 */
public enum TicketTypeStateEnum {
	
	/**
	 * 在线咨询
	 */
	type1("在线咨询", (byte) 1),
	
	/**
	 * 电话咨询
	 */
	type2("电话咨询", (byte) 2),
	
	/**
	 * 问诊(就诊)
	 */
	type3("问诊", (byte) 3),

	/**
	 * 住院
	 */
	type4("住院", (byte) 4),
	
	/**
	 * 手术
	 */
	type5("手术", (byte) 5),
	
	/**
	 * 通用健康卷(电话及在线都可用)
	 */
	type6("通用", (byte) 6);

	// 成员变量
	private Byte state;
	private String value;

	// 构造方法
	private TicketTypeStateEnum(String value, Byte state) {
		this.state = state;
		this.value = value;
	}

	// get set 方法

	/**
	 * @return the state
	 */
	public Byte getState() {
		return state;
	}

	/**
	 * @param state
	 *            the state to set
	 */
	public void setState(Byte state) {
		this.state = state;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	// 普通方法
	public static String getValue(Integer state) {
		if (state == null) {
			return null;
		}
		for (TicketTypeStateEnum c : TicketTypeStateEnum.values()) {
			if (c.getState().equals(state)) {
				return c.value;
			}
		}
		return null;
	}
}
