/**
 * 
 */
package cn.smarthse.modules.healthadvisor;

import java.util.List;

import cn.smarthse.modules.healthadvisor.enums.TicketTypeStateEnum;
import cn.smarthse.modules.healthadvisor.model.CorpHealthTicket;
import cn.smarthse.modules.healthadvisor.model.DoctorUserModel;
import cn.smarthse.modules.healthadvisor.model.HaUserCheckModel;
import cn.smarthse.modules.healthadvisor.model.HealthAdviorUserModel;
import cn.smarthse.modules.healthadvisor.model.UserTicket;
import cn.smarthse.modules.platform.toC.model.UserThirdModel;

/**
 * 《健康顾问  接口实现接口类》
 * 由软件2.0实现该接口文件,并注册到dobbo
 * 
 * @Project:  platform-facade-api
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-12-下午4:05:59
 */
public interface IHealthAdvisorService {
	//TODO 健康顾问接口定义
	
	
	/**
	 * 根据cid查询健康券数量
	 * @param type 健康券类型
	 * @param cid 企业id
	 * @return
	 */
	CorpHealthTicket getByType(TicketTypeStateEnum type,Long cid);
	
	
	/**
	 * 根据平台userid查询健康券数量
	 * @param type
	 * @param uid
	 * @return
	 */
	Integer getNumByUid(TicketTypeStateEnum type,Long uid);
	
	/**
	 * 新增用户
	 * @param userId 平台userId
	 * @param cid 企业id
	 * @param token 企业用户token
	 */
	void addHaUser(HealthAdviorUserModel wuser);
	
//	/**
//	 * 禁用用户/医生
//	 * 
//	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
//	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
//	 * @since 2018年5月3日-下午5:09:50
//	 * @param doctorModel
//	 * @return
//	 */
//	Integer syncDisableUser(DoctorUserModel doctorModel);
	
//	/**
//	 * 激活用户/医生
//	 * 
//	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
//	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
//	 * @since 2018年5月3日-下午5:09:50
//	 * @param doctorModel
//	 * @return
//	 */
//	Integer syncEnableUser(DoctorUserModel doctorModel);
//	
	/**
	 * 新增医生
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月3日-下午5:09:50
	 * @param doctorModel
	 * @return
	 */
	void syncAddDoctorUser(DoctorUserModel doctorModel);
	
	/**
	 * 编辑医生
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月3日-下午5:09:50
	 * @param doctorModel
	 * @return
	 */
	void syncUpdateDoctorUser(DoctorUserModel doctorModel);
//	
//	/**
//	 * 更新医生
//	 * 
//	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
//	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
//	 * @since 2018年5月3日-下午5:09:50
//	 * @param doctorModel
//	 * @return
//	 */
//	Integer syncUpdateDoctorUser(DoctorUserModel doctorModel);
	
	
	/**
	 * 健康券分配
	 * @param ticket
	 * @return
	 */
	String ticketDistribution(UserTicket ticket);
	
	
	/**
	 * 查询分配日志
	 * @return
	 */
	List<UserTicket> getDistributionLogByCid(Long cid);


	/**
	 * 处理 健康顾问 邀请用户信息接口
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年5月8日-下午5:34:37
	 * @param userThirdModel	第三方用户信息
	 * @param isDoctor			是否医生
	 * @param inviteUserId		邀请平台Id
	 */
	Integer processInviteUserInfo(UserThirdModel userThirdModel, Boolean isDoctor, Long inviteUserId);
	
	/**
	 * 健康顾问医生用户认证同步到平台用户实名认证
	 * @return
	 */
	void doctorCheck(DoctorUserModel doctorUserModel, Long adminId);
	
	/**
	 * 健康顾问个人用户认证同步到平台用户实名认证
	 * @return
	 */
	void userCheck(Long id, Byte checkState, String fullname, String certNo, Long adminId);
	
	/**
	 * 实名认证同步
	 * @param check
	 */
	void check(HaUserCheckModel check);
}
