/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.esserviceimpl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.util.loges.SysRequestLog;
import cn.smarthse.es.entity.SysRequestLogDoc;
import cn.smarthse.es.esservice.ISysRequestLogEsService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndexQueryBuilder;
import org.springframework.stereotype.Service;

@DubboService
@Service
public class SysRequestLogEsServiceImpl
implements ISysRequestLogEsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysRequestLogEsServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;
    public static final Integer batchSize = 2000;

    public void batchAdd(List<SysRequestLog> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        List batches = Lists.partition(logs, (int)batchSize);
        batches.forEach(batch -> {
            List<IndexQuery> indexQueries = batch.stream().filter(l -> ObjectUtil.isNotNull((Object)l)).map(log -> {
                SysRequestLogDoc conversion = this.conversion((SysRequestLog)log);
                return new IndexQueryBuilder().withObject((Object)conversion).build();
            }).collect(Collectors.toList());
            this.executeWithRetry(indexQueries, 3);
        });
    }

    private void executeWithRetry(List<IndexQuery> queries, int maxRetries) {
        int retryCount = 0;
        while (retryCount <= maxRetries) {
            try {
                this.elasticSearchTemplate.bulkIndex(queries, IndexCoordinates.of((String[])new String[]{"sys_request_log_doc"}));
                break;
            }
            catch (Exception e) {
                if (++retryCount > maxRetries) {
                    log.error("ES\u6279\u91cf\u63d2\u5165\u6700\u7ec8\u5931\u8d25\uff0c\u6279\u6b21\u5927\u5c0f: {}", (Object)queries.size(), (Object)e);
                    break;
                }
                log.warn("ES\u6279\u91cf\u63d2\u5165\u91cd\u8bd5\u4e2d({}/{}), \u9519\u8bef: {}", new Object[]{retryCount, maxRetries, e.getMessage()});
            }
        }
    }

    public SysRequestLogDoc conversion(SysRequestLog sysLog) {
        SysRequestLogDoc logDoc = new SysRequestLogDoc();
        logDoc.setCid(sysLog.getCid());
        logDoc.setCompanyName(sysLog.getCompanyName());
        logDoc.setUsername(sysLog.getUsername());
        logDoc.setFullname(sysLog.getFullname());
        logDoc.setRemoteIp(sysLog.getRemoteIp());
        logDoc.setUserAgent(sysLog.getUserAgent());
        logDoc.setRequestUri(sysLog.getRequestUri());
        logDoc.setRequestMethod(sysLog.getRequestMethod());
        logDoc.setParams(sysLog.getParams());
        logDoc.setLogSource(sysLog.getLogSource());
        logDoc.setConsumesTime(sysLog.getConsumesTime());
        logDoc.setOperateDate(sysLog.getOperateDate());
        return logDoc;
    }
}

