/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.esserviceimpl;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.es.entity.SysLoginLogsDoc;
import cn.smarthse.es.esservice.ISysLoginStateV2EsService;
import cn.smarthse.modules.health.entity.sys.SysLoginStatV2;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermLookup;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DateRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregation;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHits;

@DubboService
public class SysLoginStateV2EsServiceImpl
implements ISysLoginStateV2EsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLoginStateV2EsServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;

    public List<SysLoginStatV2> collectSummaryLoginState(Integer systemFlag, Integer year, Integer belongType, List<Long> inCidList, List<Long> notinCidList) {
        Map aggregates;
        AggregationsContainer cidAggregations;
        Date startDate = DateUtils.getYearFirstTime((int)year);
        Date endDate = DateUtils.getYearLastTime((int)year);
        if (Objects.equals(year, 2023)) {
            startDate = null;
        }
        if (year == 0) {
            startDate = DateUtils.getStartTime((Date)new Date());
            endDate = DateUtils.getEndTime((Date)new Date());
        }
        BoolQuery.Builder bqb = QueryBuilders.bool();
        bqb.must(DateRangeQuery.of(f -> (ObjectBuilder)f.field("createDate").gte((Object)DateUtil.format((Date)DateUtils.parseDate((Object)"2025-11-01 00:00:00"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")))._toRangeQuery()._toQuery(), new Query[0]);
        if (startDate != null) {
            Date finalStartDate = startDate;
            bqb.must(DateRangeQuery.of(f -> (ObjectBuilder)f.field("createDate").gte((Object)DateUtil.format((Date)finalStartDate, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")))._toRangeQuery()._toQuery(), new Query[0]);
        }
        if (endDate != null) {
            Date finalEndDate = endDate;
            bqb.must(DateRangeQuery.of(f -> (ObjectBuilder)f.field("createDate").lte((Object)DateUtil.format((Date)finalEndDate, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")))._toRangeQuery()._toQuery(), new Query[0]);
        }
        bqb.must(QueryBuilders.match(m -> m.field("logSource").query((long)systemFlag.intValue())), new Query[0]);
        if (CollectionUtils.isNotEmpty(inCidList)) {
            bqb.must(m -> m.terms(t -> t.field("cid").terms(ts -> ts.value(inCidList.stream().map(FieldValue::of).collect(Collectors.toList())))));
        }
        if (CollectionUtils.isNotEmpty(notinCidList)) {
            bqb.mustNot(m -> m.terms(t -> t.field("cid").terms(ts -> ts.value(notinCidList.stream().map(FieldValue::of).collect(Collectors.toList())))));
        }
        Aggregation loginStateAggr2 = Aggregation.of(a -> a.multiTerms(mt -> mt.terms(List.of(MultiTermLookup.of(t -> t.field("provinceId").missing(0L)), MultiTermLookup.of(t -> t.field("cityId").missing(0L)), MultiTermLookup.of(t -> t.field("areaId").missing(0L)), MultiTermLookup.of(t -> t.field("streetId").missing(0L)))).size(Integer.valueOf(Integer.MAX_VALUE))));
        Query loginQuery = bqb.build()._toQuery();
        NativeQueryBuilder nativeQueryBuilder = NativeQuery.builder().withQuery(loginQuery).withAggregation("groupBy", loginStateAggr2);
        NativeQuery query = nativeQueryBuilder.build();
        query.setTrackTotalHits(Boolean.valueOf(true));
        ArrayList<SysLoginStatV2> result = new ArrayList<SysLoginStatV2>();
        SearchHits search = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)query, SysLoginLogsDoc.class);
        if (search.hasAggregations() && (cidAggregations = search.getAggregations()) != null && (aggregates = ((ElasticsearchAggregations)cidAggregations).aggregationsAsMap()) != null) {
            ElasticsearchAggregation groupBy = (ElasticsearchAggregation)aggregates.get("groupBy");
            org.springframework.data.elasticsearch.client.elc.Aggregation aggregation1 = groupBy.aggregation();
            Aggregate aggregate = aggregation1.getAggregate();
            MultiTermsAggregate multiTermsAggregate = aggregate.multiTerms();
            for (MultiTermsBucket provinceIdTermsBucket : multiTermsAggregate.buckets().array()) {
                List areaIdList = provinceIdTermsBucket.key();
                if (CollectionUtils.isEmpty((Collection)areaIdList)) continue;
                Long areaId = 0L;
                for (FieldValue fieldValue : areaIdList) {
                    if (fieldValue == null || fieldValue.isNull() || Objects.equals(fieldValue.longValue(), 0L)) continue;
                    areaId = fieldValue.longValue();
                }
                SysLoginStatV2 sysLoginStat = new SysLoginStatV2();
                sysLoginStat.setSystemFlag(systemFlag);
                sysLoginStat.setYears(year);
                sysLoginStat.setBelongType(belongType);
                sysLoginStat.setAreaId(areaId);
                long loginCount = provinceIdTermsBucket.docCount();
                sysLoginStat.setLoginCount(Long.valueOf(loginCount));
                result.add(sysLoginStat);
            }
        }
        return result;
    }
}

