/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.esserviceimpl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.es.converter.SysLoginLogConverter;
import cn.smarthse.es.entity.CompanyDoc;
import cn.smarthse.es.entity.SysLoginLogsDoc;
import cn.smarthse.es.esdao.SysLoginLogEsDao;
import cn.smarthse.es.esservice.ISysLoginLogEsService;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.entity.sys.SysLoginStat;
import cn.smarthse.modules.health.entity.sys.SysLoginStatV2;
import cn.smarthse.modules.health.model.syslog.SysLogSearchParam;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MaxAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermLookup;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.TopHitsAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DateRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhraseQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.alibaba.excel.util.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.client.elc.Aggregation;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregation;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.util.StopWatch;

@DubboService
public class SysLoginLogEsServiceImpl
implements ISysLoginLogEsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLoginLogEsServiceImpl.class);
    @Autowired
    SysLoginLogEsDao dao;
    @Autowired
    private Snowflake snowflake;
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;
    @Autowired
    private SysLoginLogConverter converter;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService superviseService;
    @Autowired
    private RedisClient redisClient;
    private static final String CACHE_NAME = "smarthse-es:SysLoginLogEsServiceImpl";
    @Autowired
    ElasticsearchClient elasticsearchClient;

    public void addLog(SysLog logs) {
        SysLoginLogsDoc sysLogsDoc = this.converter.entity2doc(logs);
        try {
            long l = this.snowflake.nextId();
            sysLogsDoc.setId(l);
            SysLoginLogsDoc sysLoginLogsDoc = (SysLoginLogsDoc)this.dao.save(sysLogsDoc);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58es\u5f02\u5e38{}", (Throwable)e);
        }
    }

    public List<Long> getInvalidCidList() {
        List companySuperviseModels1 = (List)this.redisClient.get(CACHE_NAME, "getInvalidCidList", 7200L, () -> {
            List companySuperviseModels = this.superviseService.listInvalidCid();
            return companySuperviseModels;
        });
        if (CollectionUtils.isNotEmpty((Collection)companySuperviseModels1)) {
            return companySuperviseModels1.stream().map(CompanyBaseInfoModel::getId).distinct().collect(Collectors.toList());
        }
        return null;
    }

    public List<Long> getLoginedCidList(List<Long> cids) {
        ElasticsearchAggregation distinctCid;
        Aggregate aggregate;
        LongTermsAggregate lterms;
        Map aggregates;
        AggregationsContainer aggregationsContainer;
        BoolQuery.Builder bqb = QueryBuilders.bool();
        bqb.must(m -> m.terms(t -> t.field("cid").terms(ts -> ts.value(cids.stream().map(FieldValue::of).collect(Collectors.toList())))));
        NativeQuery query = NativeQuery.builder().withQuery(bqb.build()._toQuery()).withAggregation("distinct_cid", AggregationBuilders.terms(a -> a.field("cid").size(Integer.valueOf(Integer.MAX_VALUE)))).build();
        query.addSourceFilter((SourceFilter)new FetchSourceFilter(new String[]{"cid"}, null));
        query.setTrackScores(true);
        SearchHits search = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)query, SysLoginLogsDoc.class);
        List<Long> cidList = new ArrayList<Long>();
        if (search.hasAggregations() && (aggregationsContainer = search.getAggregations()) != null && MapUtil.isNotEmpty((Map)(aggregates = ((ElasticsearchAggregations)aggregationsContainer).aggregationsAsMap())) && (lterms = (aggregate = (distinctCid = (ElasticsearchAggregation)aggregates.get("distinct_cid")).aggregation().getAggregate()).lterms()) != null && CollectionUtils.isNotEmpty((Collection)lterms.buckets().array())) {
            cidList = lterms.buckets().array().stream().map(m -> m.key()).collect(Collectors.toList());
        }
        return cidList;
    }

    public List<Long> getLevelCidList(Long orgAreaId, Byte orgLevel) {
        List companySuperviseModels1 = (List)this.redisClient.get(CACHE_NAME, "getLevelCidList", 7200L, () -> {
            List companySuperviseModels = this.superviseService.listCityLevelCid(orgAreaId, orgLevel);
            return companySuperviseModels;
        });
        return companySuperviseModels1;
    }

    public PageInfo<SysLoginStat> queryNoLoginNum(SysLogSearchParam param, int pageNum, int size) {
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)size);
        BoolQuery.Builder companyQuery = QueryBuilders.bool();
        companyQuery.must(MatchQuery.of(m -> m.field("logined").query(false))._toQuery(), new Query[0]);
        if (param.getAreaId() != null && param.getAreaId() != 0L) {
            BoolQuery.Builder bqbAreaCondi = QueryBuilders.bool();
            bqbAreaCondi.should(QueryBuilders.match(m -> m.field("provinceId").query(param.getAreaId().longValue())), new Query[]{QueryBuilders.match(m -> m.field("cityId").query(param.getAreaId().longValue())), QueryBuilders.match(m -> m.field("areaId").query(param.getAreaId().longValue())), QueryBuilders.match(m -> m.field("streetId").query(param.getAreaId().longValue()))});
            companyQuery.must(bqbAreaCondi.build()._toQuery(), new Query[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSearchKey())) {
            companyQuery.must(MatchPhraseQuery.of(m -> m.field("name").query(param.getSearchKey()))._toQuery(), new Query[0]);
        }
        NativeQuery pageQuery = ((NativeQueryBuilder)NativeQuery.builder().withQuery(companyQuery.build()._toQuery()).withPageable((Pageable)pageable)).build();
        Page loginStatsPage = new Page();
        pageQuery.setTrackTotalHits(Boolean.valueOf(true));
        SearchHits pageSearchHis = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)pageQuery, CompanyDoc.class);
        SearchPage page = SearchHitSupport.searchPageFor((SearchHits)pageSearchHis, (Pageable)pageQuery.getPageable());
        loginStatsPage.setPageNum(pageNum);
        loginStatsPage.setPageSize(size);
        loginStatsPage.setTotal(page.getTotalElements());
        List list = page.get().map(SearchHit::getContent).collect(Collectors.toList());
        loginStatsPage.addAll(list);
        PageInfo pageInfo1 = loginStatsPage.toPageInfo(l -> {
            SysLoginStat s = new SysLoginStat();
            s.setCid(l.getId());
            s.setCompanyName(l.getName());
            s.setLoginCount(Long.valueOf(0L));
            return s;
        });
        return pageInfo1;
    }

    public PageInfo<SysLoginStat> queryLoginNum(SysLogSearchParam param, int pageNum, int size) {
        List<Long> cityLevelCid;
        if (Objects.equals(param.getNoLogin(), true)) {
            return this.queryNoLoginNum(param, pageNum, size);
        }
        BoolQuery.Builder bqb = QueryBuilders.bool();
        if (param.getAreaId() != null && param.getAreaId() != 0L) {
            BoolQuery.Builder bqbAreaCondi = QueryBuilders.bool();
            bqbAreaCondi.should(QueryBuilders.match(m -> m.field("provinceId").query(param.getAreaId().longValue())), new Query[]{QueryBuilders.match(m -> m.field("cityId").query(param.getAreaId().longValue())), QueryBuilders.match(m -> m.field("areaId").query(param.getAreaId().longValue())), QueryBuilders.match(m -> m.field("streetId").query(param.getAreaId().longValue()))});
            bqb.must(bqbAreaCondi.build()._toQuery(), new Query[0]);
        }
        bqb.must(QueryBuilders.match(m -> m.field("isValid").query(true)), new Query[0]);
        if (param.getStart() != null) {
            bqb.must(DateRangeQuery.of(f -> (ObjectBuilder)f.field("createDate").gte((Object)DateUtil.format((Date)param.getStart(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")))._toRangeQuery()._toQuery(), new Query[0]);
        }
        if (param.getEnd() != null) {
            bqb.must(DateRangeQuery.of(f -> (ObjectBuilder)f.field("createDate").lte((Object)DateUtil.format((Date)param.getEnd(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")))._toRangeQuery()._toQuery(), new Query[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSearchKey())) {
            bqb.must(QueryBuilders.matchPhrase(p -> p.field("companyName").query(param.getSearchKey())), new Query[0]);
        }
        if (param.getLogSource() != null) {
            bqb.must(QueryBuilders.match(p -> p.field("logSource").query((long)param.getLogSource().byteValue())), new Query[0]);
        }
        Integer showThisLevel = param.getShowThisLevel();
        Byte areaLevel = param.getAreaLevel();
        List<Long> invalidCidList = this.getInvalidCidList();
        ArrayList<Long> validCidList = new ArrayList<Long>();
        if (Objects.equals(areaLevel, (byte)1)) {
            if (Objects.equals(showThisLevel, 1)) {
                return new PageInfo();
            }
        } else if (Objects.equals(areaLevel, (byte)2)) {
            if (Objects.equals(showThisLevel, 1)) {
                List<Long> tempList = this.getLevelCidList(param.getAreaId(), areaLevel);
                if (CollectionUtils.isEmpty(tempList)) {
                    return new PageInfo();
                }
                validCidList.addAll(tempList);
            } else if (Objects.equals(showThisLevel, 2) && CollectionUtils.isNotEmpty(cityLevelCid = this.getLevelCidList(param.getAreaId(), areaLevel))) {
                invalidCidList.addAll(cityLevelCid);
            }
        } else if (Objects.equals(areaLevel, (byte)3) && CollectionUtils.isNotEmpty(cityLevelCid = this.getLevelCidList(param.getAreaId(), areaLevel))) {
            invalidCidList.addAll(cityLevelCid);
        }
        if (CollectionUtils.isNotEmpty(validCidList)) {
            bqb.must(m -> m.terms(t -> t.field("cid").terms(ts -> ts.value(validCidList.stream().map(FieldValue::of).collect(Collectors.toList())))));
        }
        if (CollectionUtils.isNotEmpty(invalidCidList)) {
            bqb.mustNot(m -> m.terms(t -> t.field("cid").terms(ts -> ts.value(invalidCidList.stream().map(FieldValue::of).collect(Collectors.toList())))));
        }
        Query loginQuery = bqb.build()._toQuery();
        NativeQuery countQuery = NativeQuery.builder().withQuery(loginQuery).withAggregation("cidTotal", AggregationBuilders.cardinality(c -> (ObjectBuilder)c.field("cid"))).build();
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)size);
        co.elastic.clients.elasticsearch._types.aggregations.Aggregation loginStateAggr = co.elastic.clients.elasticsearch._types.aggregations.Aggregation.of(arg_0 -> SysLoginLogEsServiceImpl.lambda$queryLoginNum$42((Pageable)pageable, size, arg_0));
        NativeQueryBuilder nativeQueryBuilder = NativeQuery.builder().withQuery(loginQuery).withAggregation("groupByCid", loginStateAggr);
        PageInfo pageInfo = new PageInfo();
        StopWatch sw = new StopWatch();
        NativeQuery query = nativeQueryBuilder.build();
        try {
            Map aggregates;
            AggregationsContainer cidAggregations;
            query.setTrackTotalHits(Boolean.valueOf(true));
            Long totalSize = (Long)this.redisClient.get(CACHE_NAME, "countQuery:" + param.hashCode(), 7200L, () -> {
                AggregationsContainer cidAggregations;
                SearchHits countResult = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)countQuery, SysLoginLogsDoc.class);
                if (countResult.hasAggregations() && (cidAggregations = countResult.getAggregations()) != null) {
                    Map aggregates = ((ElasticsearchAggregations)cidAggregations).aggregationsAsMap();
                    ElasticsearchAggregation cidTotalAggregation = (ElasticsearchAggregation)aggregates.get("cidTotal");
                    Aggregate cidTotal = cidTotalAggregation.aggregation().getAggregate();
                    CardinalityAggregate cardinality = cidTotal.cardinality();
                    return cardinality.value();
                }
                return null;
            });
            ArrayList<SysLoginStat> result = new ArrayList<SysLoginStat>();
            sw.start("\u67e5\u8be2\u5206\u9875\u5217\u8868");
            SearchHits search = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)query, SysLoginLogsDoc.class);
            sw.stop();
            log.info("StopWatch\u4fe1\u606f:{}", (Object)sw.prettyPrint());
            log.info("es \u67e5\u8be2\u603b\u8017\u65f6\uff1a{}s", (Object)sw.getTotalTimeSeconds());
            if (search.hasAggregations() && (cidAggregations = search.getAggregations()) != null && (aggregates = ((ElasticsearchAggregations)cidAggregations).aggregationsAsMap()) != null) {
                ElasticsearchAggregation groupByCid = (ElasticsearchAggregation)aggregates.get("groupByCid");
                Aggregation aggregation1 = groupByCid.aggregation();
                Aggregate aggregate = aggregation1.getAggregate();
                LongTermsAggregate byCidAggr = aggregate.lterms();
                for (LongTermsBucket longTermsBucket : byCidAggr.buckets().array()) {
                    TopHitsAggregate topHitsAggregate;
                    long cid = longTermsBucket.key();
                    Map byCidAggrMap = longTermsBucket.aggregations();
                    Aggregate loginCount = (Aggregate)byCidAggrMap.get("loginCount");
                    Aggregate topCompanyName = (Aggregate)byCidAggrMap.get("topCompanyName");
                    Aggregate createDateAggregate = (Aggregate)byCidAggrMap.get("maxCreateDate");
                    MaxAggregate createDateMax = createDateAggregate.max();
                    SysLoginStat sysLoginStat = new SysLoginStat();
                    sysLoginStat.setId(Long.valueOf(IdWorker.getId()));
                    if (topCompanyName != null && (topHitsAggregate = topCompanyName.topHits()) != null && CollectionUtils.isNotEmpty((Collection)topHitsAggregate.hits().hits())) {
                        Hit jsonDataHit = (Hit)topHitsAggregate.hits().hits().get(0);
                        SysLoginStat nameTemp = (SysLoginStat)((JsonData)jsonDataHit.source()).to(SysLoginStat.class);
                        sysLoginStat.setCompanyName(nameTemp.getCompanyName());
                    }
                    if (createDateMax != null) {
                        Date date = DateUtils.utcToLocal((String)createDateMax.valueAsString());
                        sysLoginStat.setLastLoginDate(date);
                    }
                    if (loginCount != null) {
                        double value = loginCount.valueCount().value();
                        sysLoginStat.setLoginCount(Convert.toLong((Object)value));
                    }
                    sysLoginStat.setCid(Long.valueOf(cid));
                    result.add(sysLoginStat);
                }
            }
            Page page = new Page();
            page.setPageNum(pageNum);
            page.setPageSize(size);
            page.setTotal(totalSize.longValue());
            page.addAll(result);
            pageInfo = page.toPageInfo();
        }
        catch (Exception e) {
            log.error("\u641c\u7d22es\u5f02\u5e38{}", (Throwable)e);
        }
        return pageInfo;
    }

    public SysLog getById(Long id) {
        Optional byId = this.dao.findById(id);
        return this.converter.doc2entity((SysLoginLogsDoc)byId.get());
    }

    public List<SysLoginStatV2> collectAreaIsNullLog() {
        Map aggregates;
        AggregationsContainer cidAggregations;
        BoolQuery.Builder bqbAreaCondi = QueryBuilders.bool();
        bqbAreaCondi.mustNot(QueryBuilders.exists(e -> e.field("provinceId")), new Query[0]);
        co.elastic.clients.elasticsearch._types.aggregations.Aggregation loginStateAggr2 = co.elastic.clients.elasticsearch._types.aggregations.Aggregation.of(a -> a.multiTerms(mt -> mt.terms(List.of(MultiTermLookup.of(t -> t.field("logSource")), MultiTermLookup.of(t -> t.field("createBy")))).size(Integer.valueOf(Integer.MAX_VALUE))));
        Query loginQuery = bqbAreaCondi.build()._toQuery();
        NativeQueryBuilder nativeQueryBuilder = NativeQuery.builder().withQuery(loginQuery).withAggregation("groupBy", loginStateAggr2);
        NativeQuery query = nativeQueryBuilder.build();
        query.setTrackTotalHits(Boolean.valueOf(true));
        ArrayList<SysLoginStatV2> result = new ArrayList<SysLoginStatV2>();
        SearchHits search = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)query, SysLoginLogsDoc.class);
        if (search.hasAggregations() && (cidAggregations = search.getAggregations()) != null && (aggregates = ((ElasticsearchAggregations)cidAggregations).aggregationsAsMap()) != null) {
            ElasticsearchAggregation groupBy = (ElasticsearchAggregation)aggregates.get("groupBy");
            Aggregation aggregation1 = groupBy.aggregation();
            Aggregate aggregate = aggregation1.getAggregate();
            MultiTermsAggregate multiTermsAggregate = aggregate.multiTerms();
            for (MultiTermsBucket provinceIdTermsBucket : multiTermsAggregate.buckets().array()) {
                List areaIdList = provinceIdTermsBucket.key();
                if (CollectionUtils.isEmpty((Collection)areaIdList)) continue;
                SysLoginStatV2 d = new SysLoginStatV2();
                if (!((FieldValue)areaIdList.get(0)).isLong()) {
                    log.error("\u7edf\u8ba1\u767b\u5f55\u8bb0\u5f55\u884c\u653f\u533a\u5212\u4e3a\u7a7a\u7684\u6570\u636e\u4efb\u52a1\uff1a\u7edf\u8ba1\u6570\u636e\u5b58\u5728\u4e0d\u662f\u6570\u5b57\u7684\u6570\u636e{}", (Object)((FieldValue)areaIdList.get(0)).toString());
                    continue;
                }
                d.setSystemFlag(Convert.toInt((Object)((FieldValue)areaIdList.get(0)).longValue()));
                if (!((FieldValue)areaIdList.get(1)).isNull() && ((FieldValue)areaIdList.get(1)).isLong()) {
                    d.setCreateBy(Long.valueOf(((FieldValue)areaIdList.get(1)).longValue()));
                }
                long loginCount = provinceIdTermsBucket.docCount();
                d.setLoginCount(Long.valueOf(loginCount));
                result.add(d);
            }
        }
        return result;
    }

    public void updateAreaIsNullLog(Byte logSource, Long createBy, SysArea sysArea) {
        if (logSource == null || createBy == null || sysArea == null || sysArea.getProvinceId() == null) {
            return;
        }
        BoolQuery.Builder bqbAreaCondi = QueryBuilders.bool();
        bqbAreaCondi.must(QueryBuilders.term(t -> t.field("logSource").value((long)logSource.byteValue())), new Query[]{QueryBuilders.term(t -> t.field("createBy").value(createBy.longValue()))});
        bqbAreaCondi.mustNot(QueryBuilders.exists(e -> e.field("provinceId")), new Query[0]);
        StringBuilder scriptSource = new StringBuilder();
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        if (sysArea.getProvinceId() != null) {
            scriptSource.append("ctx._source.provinceId = params.provinceId; ");
            params.put("provinceId", JsonData.of((Object)sysArea.getProvinceId()));
        }
        if (sysArea.getCityId() != null) {
            scriptSource.append("ctx._source.cityId = params.cityId; ");
            params.put("cityId", JsonData.of((Object)sysArea.getCityId()));
        }
        if (sysArea.getAreaId() != null) {
            scriptSource.append("ctx._source.areaId = params.areaId; ");
            params.put("areaId", JsonData.of((Object)sysArea.getAreaId()));
        }
        if (sysArea.getStreetId() != null) {
            scriptSource.append("ctx._source.streetId = params.streetId; ");
            params.put("streetId", JsonData.of((Object)sysArea.getStreetId()));
        }
        if (params.isEmpty()) {
            System.out.println("No fields to update");
            return;
        }
        UpdateByQueryRequest request = UpdateByQueryRequest.of(u -> u.index("sysloginlog_aliase", new String[0]).query(bqbAreaCondi.build()._toQuery()).script(s -> s.source(scriptSource.toString()).params(params)).conflicts(Conflicts.Proceed).refresh(Boolean.valueOf(true)));
        try {
            UpdateByQueryResponse response = this.elasticsearchClient.updateByQuery(request);
            log.error("\u66f4\u65b0\u603b\u6761\u6570\uff1a{}", (Object)response.updated());
            log.error("\u603b\u6761\u6570\uff1a{}", (Object)response.total());
        }
        catch (IOException e2) {
            e2.printStackTrace();
            log.error("\u66f4\u65b0\u5f02\u5e38\u62a5\u9519{}", (Object)e2.getMessage());
        }
    }

    private static /* synthetic */ ObjectBuilder lambda$queryLoginNum$42(Pageable pageable, int size, Aggregation.Builder a) {
        return a.terms(byCid -> byCid.field("cid").size(Integer.valueOf(Integer.MAX_VALUE))).aggregations(Map.of("loginCount", co.elastic.clients.elasticsearch._types.aggregations.Aggregation.of(count -> count.valueCount(v -> (ObjectBuilder)v.field("cid"))), "maxCreateDate", co.elastic.clients.elasticsearch._types.aggregations.Aggregation.of(date -> date.max(m -> (ObjectBuilder)m.field("createDate"))), "loginCountSort", AggregationBuilders.bucketSort(bs -> bs.sort(s -> s.field(f -> f.field("loginCount").order(SortOrder.Desc))).from(Integer.valueOf((int)pageable.getOffset())).size(Integer.valueOf(size))), "topCompanyName", co.elastic.clients.elasticsearch._types.aggregations.Aggregation.of(name -> name.topHits(top -> top.source(s -> s.filter(f -> f.includes("companyName", new String[0]))).size(Integer.valueOf(1))))));
    }
}

