/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.esserviceimpl;

import cn.hutool.core.lang.Snowflake;
import cn.smarthse.es.converter.SysLogConverter;
import cn.smarthse.es.entity.SysLogsDoc;
import cn.smarthse.es.esdao.CompanyEsDao;
import cn.smarthse.es.esdao.SysLogEsDao;
import cn.smarthse.es.esservice.ISysLogEsService;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.model.syslog.SysLogSearchParam;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOptionsBuilders;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhraseQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import com.alibaba.excel.util.StringUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;

@DubboService
public class SysLogEsServiceImpl
implements ISysLogEsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLogEsServiceImpl.class);
    @Autowired
    SysLogEsDao dao;
    @Autowired
    CompanyEsDao companyEsDao;
    @Autowired
    private Snowflake snowflake;
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;
    @Autowired
    private SysLogConverter converter;

    public void addLog(SysLog logs) {
        SysLogsDoc sysLogsDoc = this.converter.entity2doc(logs);
        try {
            long l = this.snowflake.nextId();
            sysLogsDoc.setId(l);
            SysLogsDoc sysLogsDoc2 = (SysLogsDoc)this.dao.save(sysLogsDoc);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58es\u5f02\u5e38{}", (Throwable)e);
        }
    }

    public PageInfo<SysLog> pageListByAreaId(SysLogSearchParam param, int pageNum, int size) {
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)size);
        BoolQuery.Builder bqb = QueryBuilders.bool();
        if (param.getAreaId() != null && param.getAreaId() != 0L) {
            BoolQuery.Builder bqbAreaCondi = QueryBuilders.bool();
            bqbAreaCondi.should(QueryBuilders.match(m -> m.field("provinceId").query(param.getAreaId().longValue())), new Query[]{QueryBuilders.match(m -> m.field("cityId").query(param.getAreaId().longValue())), QueryBuilders.match(m -> m.field("areaId").query(param.getAreaId().longValue())), QueryBuilders.match(m -> m.field("streetId").query(param.getAreaId().longValue()))});
            bqb.must(bqbAreaCondi.build()._toQuery(), new Query[0]);
        }
        bqb.must(QueryBuilders.match(r -> r.field("isValid").query(true)), new Query[0]);
        if (StringUtils.isNotBlank((CharSequence)param.getSearchKey())) {
            BoolQuery.Builder keyWordQuery = QueryBuilders.bool();
            keyWordQuery.should(MatchPhraseQuery.of(m -> m.field("title").query(param.getSearchKey()))._toQuery(), new Query[]{MatchPhraseQuery.of(m -> m.field("username").query(param.getSearchKey()))._toQuery()});
            bqb.must(keyWordQuery.build()._toQuery(), new Query[0]);
        }
        if (param.getLogSource() != null) {
            bqb.must(QueryBuilders.match(m -> m.field("logSource").query((long)param.getLogSource().byteValue())), new Query[0]);
        }
        if (param.getType() != null) {
            bqb.must(QueryBuilders.match(m -> m.field("type").query((long)param.getType().intValue())), new Query[0]);
        }
        SortOptions createDate = SortOptionsBuilders.field(f -> f.field("createDate").order(SortOrder.Desc));
        NativeQuery query = ((NativeQueryBuilder)NativeQuery.builder().withQuery(bqb.build()._toQuery()).withSort(createDate, new SortOptions[0]).withPageable((Pageable)pageable)).build();
        PageInfo pageInfo = new PageInfo();
        try {
            query.setTrackTotalHits(Boolean.valueOf(true));
            SearchHits search = this.elasticSearchTemplate.search((org.springframework.data.elasticsearch.core.query.Query)query, SysLogsDoc.class);
            SearchPage page = SearchHitSupport.searchPageFor((SearchHits)search, (Pageable)query.getPageable());
            pageInfo.setPageNum(pageNum);
            pageInfo.setPageSize(size);
            pageInfo.setSize(size);
            pageInfo.setPages(page.getTotalPages());
            pageInfo.setTotal(page.getTotalElements());
            List<SysLogsDoc> list = page.get().map(SearchHit::getContent).collect(Collectors.toList());
            pageInfo.setList(this.converter.entity2docs(list));
        }
        catch (Exception e) {
            log.error("\u641c\u7d22es\u5f02\u5e38{}", (Throwable)e);
        }
        return pageInfo;
    }

    public SysLog getById(Long id) {
        Optional byId = this.dao.findById(id);
        return this.converter.doc2entity((SysLogsDoc)byId.get());
    }
}

