/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.esserviceimpl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.es.converter.OrigiCipIdConverter;
import cn.smarthse.es.entity.OrigiCipIdDoc;
import cn.smarthse.es.esdao.OrigiCipIdEsDao;
import cn.smarthse.es.esservice.IOrigiCipIdEsService;
import cn.smarthse.es.model.OrigiCipIdModel;
import cn.smarthse.es.model.OrigiCipIdParamModel;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.query.Query;

@DubboService
public class OrigiCipIdEsServiceImpl
implements IOrigiCipIdEsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrigiCipIdEsServiceImpl.class);
    @Autowired
    private OrigiCipIdEsDao dao;
    @Autowired
    private OrigiCipIdConverter converter;
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;
    @Value(value="${es.query.max.retry:3}")
    private int maxRetryTimes;
    @Value(value="${es.query.max.batch.size:10000}")
    private int maxBatchSize;
    @Value(value="${es.query.retry.delay:1000}")
    private long retryDelayMillis;

    public void save(OrigiCipIdModel model) {
        if (model == null) {
            return;
        }
        OrigiCipIdDoc doc = this.converter.entity2doc(model);
        try {
            this.dao.save(doc);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58es\u5f02\u5e38", (Throwable)e);
        }
    }

    public void batchSave(List<OrigiCipIdModel> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<OrigiCipIdDoc> sysLogsDocList = this.converter.entity2docs(list);
        try {
            for (List origiCipIdDocs : ListUtil.partition(sysLogsDocList, (int)1000)) {
                this.dao.saveAll(origiCipIdDocs);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58es\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo<OrigiCipIdModel> pageByPlaintextList(OrigiCipIdParamModel paras, int pageNum, int size) {
        return this.pageByPlaintextList_base(paras, pageNum, size, Boolean.TRUE, Boolean.FALSE);
    }

    public PageInfo<OrigiCipIdModel> pageByPlaintextList_base(OrigiCipIdParamModel paras, int pageNum, int size, Boolean retry, Boolean convertQuery) {
        size = Math.min(size, this.maxBatchSize);
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)size);
        BoolQuery.Builder origiCipQuery = QueryBuilders.bool();
        if (paras != null) {
            if (paras.getCipSuccFlag() != null) {
                origiCipQuery.must(m -> m.match(f -> f.field("cipSuccFlag").query(paras.getCipSuccFlag().booleanValue())));
            }
            if (paras.getIsIdConverted() != null) {
                origiCipQuery.must(m -> m.match(f -> f.field("isIdConverted").query(paras.getIsIdConverted().booleanValue())));
            }
            if (Boolean.TRUE.equals(convertQuery)) {
                origiCipQuery.mustNot(m -> m.match(f -> f.field("isIdConverted").query(Boolean.TRUE.booleanValue())));
            }
            if (CollectionUtils.isNotEmpty((Collection)paras.getOrgiDatas())) {
                List orgiDatas = paras.getOrgiDatas();
                origiCipQuery.must(m -> m.ids(s -> s.values(orgiDatas)));
            }
        }
        NativeQuery pageQuery = ((NativeQueryBuilder)NativeQuery.builder().withQuery(origiCipQuery.build()._toQuery()).withPageable((Pageable)pageable)).build();
        if (Boolean.TRUE.equals(retry)) {
            return this.executeQueryWithRetry(pageQuery, pageNum, size);
        }
        return this.executeQuery(pageQuery, pageNum, size);
    }

    public PageInfo<OrigiCipIdModel> pageByCiphertextList(OrigiCipIdParamModel paras, int pageNum, int size, Boolean retry) {
        size = Math.min(size, this.maxBatchSize);
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)size);
        BoolQuery.Builder origiCipQuery = QueryBuilders.bool();
        if (paras != null) {
            if (paras.getCipSuccFlag() != null) {
                origiCipQuery.must(m -> m.match(f -> f.field("cipSuccFlag").query(paras.getCipSuccFlag().booleanValue())));
            }
            if (paras.getIsIdConverted() != null) {
                origiCipQuery.must(m -> m.match(f -> f.field("isIdConverted").query(paras.getIsIdConverted().booleanValue())));
            }
            if (CollectionUtils.isNotEmpty((Collection)paras.getCipDatas())) {
                List cipDatas = paras.getCipDatas();
                origiCipQuery.must(m -> m.terms(t -> t.field("cipData").terms(terms -> terms.value(cipDatas.stream().map(FieldValue::of).collect(Collectors.toList())))));
            }
        }
        NativeQuery pageQuery = ((NativeQueryBuilder)NativeQuery.builder().withQuery(origiCipQuery.build()._toQuery()).withPageable((Pageable)pageable)).build();
        if (Boolean.TRUE.equals(retry)) {
            return this.executeQueryWithRetry(pageQuery, pageNum, size);
        }
        return this.executeQuery(pageQuery, pageNum, size);
    }

    public Long count() {
        return this.dao.count();
    }

    public void deleteById(String id) {
        if (StrUtil.isBlank((CharSequence)id)) {
            return;
        }
        this.dao.deleteById(id);
    }

    public void deleteByIdList(List<String> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        try {
            for (List batchIds : ListUtil.partition(idList, (int)1000)) {
                this.dao.deleteAllById(batchIds);
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5220\u9664ES\u6587\u6863\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteAll() {
        this.dao.deleteAll();
    }

    public void executeBatchOperation(List<String> idsToDelete, List<OrigiCipIdModel> modelsToSave) {
        int retryCount = 0;
        while (retryCount <= this.maxRetryTimes) {
            try {
                if (CollUtil.isNotEmpty(idsToDelete)) {
                    this.deleteByIdList(idsToDelete);
                }
                if (CollUtil.isNotEmpty(modelsToSave)) {
                    this.batchSave(modelsToSave);
                }
                return;
            }
            catch (Exception e) {
                if (++retryCount > this.maxRetryTimes) {
                    log.error("\u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570 {}", (Object)this.maxRetryTimes, (Object)e);
                    throw new RuntimeException("\u6279\u91cf\u64cd\u4f5c\u5931\u8d25", e);
                }
                log.warn("\u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff0c\u51c6\u5907\u7b2c {} \u6b21\u91cd\u8bd5...", (Object)retryCount);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryDelayMillis * (long)retryCount);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("\u6279\u91cf\u64cd\u4f5c\u91cd\u8bd5\u88ab\u4e2d\u65ad", ie);
                }
            }
        }
    }

    private PageInfo<OrigiCipIdModel> executeQuery(NativeQuery pageQuery, int pageNum, int size) {
        return this.getOrigiCipIdModelPageInfo(pageQuery, pageNum, size);
    }

    private PageInfo<OrigiCipIdModel> executeQueryWithRetry(NativeQuery pageQuery, int pageNum, int size) {
        int retryCount = 0;
        while (retryCount <= this.maxRetryTimes) {
            try {
                return this.getOrigiCipIdModelPageInfo(pageQuery, pageNum, size);
            }
            catch (DataAccessResourceFailureException e) {
                if (++retryCount > this.maxRetryTimes) {
                    log.error("ES\u67e5\u8be2\u5931\u8d25\uff0c\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570{}", (Object)this.maxRetryTimes, (Object)e);
                    throw e;
                }
                log.error("ES\u67e5\u8be2\u5931\u8d25\uff0c\u51c6\u5907\u7b2c{}\u6b21\u91cd\u8bd5...", (Object)retryCount);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryDelayMillis * (long)retryCount);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("\u67e5\u8be2\u91cd\u8bd5\u88ab\u4e2d\u65ad", ie);
                }
            }
        }
        throw new IllegalStateException("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef");
    }

    private PageInfo<OrigiCipIdModel> getOrigiCipIdModelPageInfo(NativeQuery pageQuery, int pageNum, int size) {
        Page orgicipPage = new Page();
        pageQuery.setTrackTotalHits(Boolean.valueOf(true));
        SearchHits pageSearchHis = this.elasticSearchTemplate.search((Query)pageQuery, OrigiCipIdDoc.class);
        SearchPage pageData = SearchHitSupport.searchPageFor((SearchHits)pageSearchHis, (Pageable)pageQuery.getPageable());
        orgicipPage.setPageNum(pageNum);
        orgicipPage.setPageSize(size);
        orgicipPage.setTotal(pageData.getTotalElements());
        List<OrigiCipIdDoc> list = pageData.get().map(SearchHit::getContent).toList();
        orgicipPage.addAll(list);
        return orgicipPage.toPageInfo(l -> this.converter.doc2model((OrigiCipIdDoc)l));
    }

    public List<OrigiCipIdModel> deepPage(OrigiCipIdParamModel paras, int pageSize) {
        BoolQuery.Builder origiCipQuery = QueryBuilders.bool();
        if (paras != null) {
            if (paras.getCipSuccFlag() != null) {
                origiCipQuery.must(m -> m.match(f -> f.field("cipSuccFlag").query(paras.getCipSuccFlag().booleanValue())));
            }
            if (CollectionUtils.isNotEmpty((Collection)paras.getOrgiDatas())) {
                List orgiDatas = paras.getOrgiDatas();
                origiCipQuery.must(m -> m.ids(s -> s.values(orgiDatas)));
            }
        }
        NativeQueryBuilder pageQueryBuilder = (NativeQueryBuilder)((NativeQueryBuilder)NativeQuery.builder().withQuery(origiCipQuery.build()._toQuery()).withPageable(Pageable.ofSize((int)pageSize))).withSort(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"orgiData.keyword")}));
        if (StringUtils.isNotBlank((CharSequence)paras.getStartId())) {
            pageQueryBuilder.withSearchAfter(List.of(paras.getStartId()));
        }
        int retryCount = 0;
        while (retryCount <= this.maxRetryTimes) {
            try {
                NativeQuery pageQuery = pageQueryBuilder.build();
                pageQuery.setTrackTotalHits(Boolean.valueOf(true));
                SearchHits pageSearchHis = this.elasticSearchTemplate.search((Query)pageQuery, OrigiCipIdDoc.class);
                List<OrigiCipIdModel> resultList = pageSearchHis.getSearchHits().stream().map(m -> this.converter.doc2model((OrigiCipIdDoc)m.getContent())).collect(Collectors.toList());
                return resultList;
            }
            catch (DataAccessResourceFailureException e) {
                if (++retryCount > this.maxRetryTimes) {
                    log.error("ES\u67e5\u8be2\u5931\u8d25\uff0c\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570{}", (Object)this.maxRetryTimes, (Object)e);
                    throw e;
                }
                log.error("ES\u67e5\u8be2\u5931\u8d25\uff0c\u51c6\u5907\u7b2c{}\u6b21\u91cd\u8bd5...", (Object)retryCount);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryDelayMillis * (long)retryCount);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("\u67e5\u8be2\u91cd\u8bd5\u88ab\u4e2d\u65ad", ie);
                }
            }
        }
        return null;
    }
}

