/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.esserviceimpl;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.es.converter.CompanyConverter;
import cn.smarthse.es.entity.CompanyDoc;
import cn.smarthse.es.esdao.CompanyEsDao;
import cn.smarthse.es.esservice.ICompanyEsService;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;

@DubboService
public class CompanyEsServiceImpl
implements ICompanyEsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyEsServiceImpl.class);
    @Autowired
    CompanyEsDao dao;
    @Autowired
    CompanyConverter converter;
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;

    public void batchAdd(List<CompanySuperviseModel> list, Date loadDate, Set<Long> loginedCidSet) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<CompanyDoc> companyDocs = new ArrayList<CompanyDoc>();
            for (CompanySuperviseModel model : list) {
                CompanyDoc companyDoc = this.converter.entity2doc(model);
                if (Objects.equals(model.getSuperviseIsHide(), true) || Objects.equals(model.getSuperviseIsDel(), true) || Objects.equals(model.getIsValid(), false)) continue;
                if (loginedCidSet.contains(companyDoc.getId())) {
                    companyDoc.setLogined(true);
                } else {
                    companyDoc.setLogined(false);
                }
                companyDocs.add(companyDoc);
            }
            for (List companyDocList : ListUtil.partition(companyDocs, (int)2000)) {
                this.dao.saveAll(companyDocList);
            }
        }
    }

    public void delQuery(Date loadDate) {
        Query loadDateQuery = QueryBuilders.range(r -> r.date(d -> (ObjectBuilder)d.field("loadDate").lt((Object)DateUtils.formatDateTime((Date)loadDate))));
        NativeQuery countQuery = NativeQuery.builder().withQuery(loadDateQuery).build();
        this.elasticSearchTemplate.delete((org.springframework.data.elasticsearch.core.query.Query)countQuery, CompanyDoc.class, IndexCoordinates.of((String[])new String[]{"company"}));
    }
}

