/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.bootstrap;

import cn.smarthse.common.util.loges.LogProperties;
import cn.smarthse.common.util.loges.SysRequestLog;
import cn.smarthse.es.esservice.ISysRequestLogEsService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class LogQueueConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogQueueConsumer.class);
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ISysRequestLogEsService sysRequestLogEsService;
    private LogProperties logProperties;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    private volatile boolean running = true;
    private RBlockingQueue<SysRequestLog> logQueue;
    private static final int POLL_TIMEOUT_SECONDS = 1;
    List<SysRequestLog> currentBatch = new ArrayList<SysRequestLog>();

    @PostConstruct
    public void init() {
        if (LogProperties.ENABLED.booleanValue()) {
            this.logQueue = this.redissonClient.getBlockingQueue("redisESLogQueue\uff1a" + LogProperties.QUEUE_NAME);
            this.taskExecutor.submit(this::consumeLogs);
        }
    }

    private void consumeLogs() {
        int retryCount = 0;
        while (this.running && !Thread.currentThread().isInterrupted()) {
            try {
                SysRequestLog log = (SysRequestLog)this.logQueue.poll(1L, TimeUnit.SECONDS);
                retryCount = 0;
                if (log == null) continue;
                this.currentBatch.add(log);
                if (this.currentBatch.size() < LogProperties.BATCH_SIZE) continue;
                Boolean aBoolean = this.flushBatch(this.currentBatch);
                this.currentBatch.clear();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (RedisException e) {
                long waitTime = Math.min(1000 * (++retryCount * 5), 30000);
                log.error("Redis\u8fde\u63a5\u5f02\u5e38\uff0c{}\u79d2\u540e\u91cd\u8bd5", (Object)(waitTime / 1000L));
                this.sleepQuietly(waitTime);
            }
            catch (Exception e) {
                log.error("ES\u6279\u91cf\u52a0\u5165\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
                this.sleepQuietly(100L);
            }
        }
        if (!this.currentBatch.isEmpty()) {
            this.flushBatch(this.currentBatch);
            this.currentBatch.clear();
        }
        log.info("ES\u65e5\u5fd7\u672b\u5c3e\u5904\u7406");
    }

    private boolean flushBatch(List<SysRequestLog> batch) {
        if (batch.isEmpty()) {
            return Boolean.FALSE;
        }
        try {
            this.sysRequestLogEsService.batchAdd(new ArrayList<SysRequestLog>(batch));
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error("ES\u6279\u91cf\u52a0\u5165\u65e5\u5fd7\u9519\u8bef\uff1a {}", (Object)batch.size(), (Object)e);
            return Boolean.FALSE;
        }
    }

    private void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @PreDestroy
    public void destroy() {
        this.flushBatch(this.currentBatch);
        this.currentBatch.clear();
        this.running = false;
        this.taskExecutor.shutdown();
    }
}

