/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.bootstrap;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="spring.elasticsearch")
@ConditionalOnProperty(name={"spring.elasticsearch.validCert"}, havingValue="false")
public class ElasticSearchConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfig.class);
    private String uris;
    private String username;
    private String password;

    @Bean
    public ElasticsearchClient elasticsearchClient() {
        ElasticsearchTransport transport = this.getElasticsearchTransport();
        return new ElasticsearchClient(transport);
    }

    @Bean
    public ElasticsearchAsyncClient elasticsearchAsyncClient() {
        ElasticsearchTransport transport = this.getElasticsearchTransport();
        return new ElasticsearchAsyncClient(transport);
    }

    private ElasticsearchTransport getElasticsearchTransport() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
            if (StringUtils.endsWith((String)this.uris, (String)"/")) {
                this.uris = this.uris.substring(0, this.uris.length() - 1);
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.uris)}).setHttpClientConfigCallback(arg_0 -> ElasticSearchConfig.lambda$getElasticsearchTransport$1(sslContext, (CredentialsProvider)credentialsProvider, arg_0));
            RestClient client = builder.build();
            return new RestClientTransport(client, (JsonpMapper)new JacksonJsonpMapper());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public ElasticSearchConfig() {
    }

    @Generated
    public String getUris() {
        return this.uris;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setUris(String uris) {
        this.uris = uris;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchConfig)) {
            return false;
        }
        ElasticSearchConfig other = (ElasticSearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uris = this.getUris();
        String other$uris = other.getUris();
        if (this$uris == null ? other$uris != null : !this$uris.equals(other$uris)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uris = this.getUris();
        result = result * 59 + ($uris == null ? 43 : $uris.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElasticSearchConfig(uris=" + this.getUris() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getElasticsearchTransport$1(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setDefaultCredentialsProvider(credentialsProvider);
    }
}

