/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.es.bootstrap;

import cn.hutool.core.lang.Snowflake;
import cn.smarthse.es.bootstrap.BaseConfiguration;
import cn.smarthse.es.bootstrap.TaskExecutorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={TaskExecutorProperties.class})
public class ContentConfiguration
extends BaseConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentConfiguration.class);

    @Bean
    public Snowflake getSnowflake() {
        return new Snowflake();
    }

    @Primary
    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor(TaskExecutorProperties taskExecutorProperties) {
        log.info("\u914d\u7f6e\u901a\u7528 ThreadPoolTaskExecutor\uff1a {}", (Object)taskExecutorProperties.getThreadNamePrefix());
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> log.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u4efb\u52a1\uff0c\u4efb\u52a1\u4e22\u5f03"));
        executor.initialize();
        return executor;
    }

    @Generated
    public ContentConfiguration() {
    }
}

